/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_array_adapter_custom_class;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class UserEditActivity extends Activity
	implements OnClickListener
{

	public static final String EXTRA_USER = "User";

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.user_edit_activity);

		Button cancelButton = (Button) findViewById(R.id.cancel_button);
		cancelButton.setOnClickListener(new OnClickListener()
		{
			public void onClick(View view)
			{
				setResult(RESULT_CANCELED);
				finish();
			}
		});

		Button saveButton = (Button) findViewById(R.id.save_button);
		saveButton.setOnClickListener(new OnClickListener()
		{
			public void onClick(View view)
			{
				Intent intent = new Intent();
				intent.putExtra(EXTRA_USER, getUser());
				setResult(RESULT_OK, intent);
				finish();
			}
		});
	}

	private User getUser()
	{
		User user = new User();

		EditText firstNameEditText = (EditText) findViewById(R.id.first_name_edittext);
		user.setFirstName(firstNameEditText.getText().toString());

		EditText lastNameEditText = (EditText) findViewById(R.id.last_name_edittext);
		user.setLastName(lastNameEditText.getText().toString());

		EditText ageEditText = (EditText) findViewById(R.id.age_edittext);
		int age = 0;
		try
		{
			age = Integer.parseInt(ageEditText.getText().toString());
		}
		catch (NumberFormatException e)
		{
		}
		user.setAge(age);

		EditText emailEditText = (EditText) findViewById(R.id.email_edittext);
		user.setEmail(emailEditText.getText().toString());

		return user;
	}

	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.cancel_button:
				setResult(RESULT_CANCELED);
				finish();
				break;
			case R.id.save_button:
				Intent intent = new Intent();
				intent.putExtra(EXTRA_USER, getUser());
				setResult(RESULT_OK, intent);
				finish();
				break;
		}
	}
}
