/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_multiple_choice_custom_layout;

import android.app.ListActivity;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MainActivity extends ListActivity
{

	private static final String LOG_TAG = "XXX";
	private static final String MAPPING_KEY_NAME = "name";
	private static final String MAPPING_KEY_EMAIL = "email";
	private static final String[] MAPPING_FROM =
	{
		MAPPING_KEY_NAME,
		MAPPING_KEY_EMAIL,
	};
	private static final int[] MAPPING_TO =
	{
		R.id.name,
		R.id.email,
	};
	private List<Map<String, String>> userList;

	/**
	 * Called when the activity is first created.
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		// Init ListAdapter
		SimpleAdapter listAdapter = new SimpleAdapter(this, getUserList(),
			R.layout.user_list_item,
			MAPPING_FROM, MAPPING_TO);
		setListAdapter(listAdapter);

		// Init ListView choice mode & default checked item
		ListView listView = getListView();
		listView.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);
		listView.setItemChecked(1, true);
		listView.setItemChecked(2, true);
	}

	@Override
	protected void onPause()
	{
		showCheckedUsers();
		super.onPause();
	}

	private List<Map<String, String>> getUserList()
	{
		if (userList == null)
		{
			userList = new ArrayList<Map<String, String>>();
			String[] userNames = getResources().getStringArray(R.array.names);
			for (int i = 0; i < userNames.length; i++)
			{
				String name = userNames[i];
				String email = name.toLowerCase() + "@example.com";
				boolean checked = false;
				if (i % 3 == 0)
				{
					checked = true;
				}

				Map<String, String> userData = new HashMap<String, String>();
				userData.put(MAPPING_KEY_NAME, name);
				userData.put(MAPPING_KEY_EMAIL, email);
				userList.add(userData);
			}
		}
		return userList;
	}

	private void showCheckedUsers()
	{
		SparseBooleanArray checkedItemPositions = getListView().getCheckedItemPositions();
		for (int i = 0; i < userList.size(); i++)
		{
			if (checkedItemPositions.get(i))
			{
				Map<String, String> userData = userList.get(i);
				String name = userData.get(MAPPING_KEY_NAME);
				String email = userData.get(MAPPING_KEY_EMAIL);
				String message = String.format("Checked User : name => %s, email => %s", name, email);
				Log.d(LOG_TAG, message);
			}
		}
	}
}
