/*
 *  The MIT License
 *
 *  Copyright 2014 Masahiko, SAWAI <say@users.sourceforge.jp>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package com.example.hello.android.listview_simple_cursor_adapter;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

public class UserDBHelper extends SQLiteOpenHelper implements UserDBConstants
{

	private static final String LOG_TAG = "XXX";
	private static final int DB_VERSION = 1;
	private static final String CREATE_TABLE_SQL = "CREATE TABLE " + TABLE_NAME + "("
		+ "  " + Columns.ID + " INTEGER PRIMARY KEY AUTOINCREMENT"
		+ ", " + Columns.NAME + " TEXT"
		+ ", " + Columns.EMAIL + " TEXT"
		+ ");";
	private static final String DROP_TABLE_SQL = "DROP TABLE " + TABLE_NAME + ";";
	private Context context;

	public UserDBHelper(Context context)
	{
		// create database on main memory
		super(context, null, null, DB_VERSION);
		this.context = context;
	}

	Cursor selectUsersByName(SQLiteDatabase db, CharSequence name)
	{
		Cursor cursor = db.query(TABLE_NAME,
			new String[]
		{
			Columns.ID,
			Columns.NAME,
			Columns.EMAIL,
		},
			Columns.NAME + " like ?",
			new String[]
		{
			'%' + name.toString() + '%'
		},
			null, null, Columns.NAME + " ASC");

		return cursor;
	}

	@Override
	public void onCreate(SQLiteDatabase db)
	{
		db.execSQL(CREATE_TABLE_SQL);
		initializeUsers(db);
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion)
	{
		db.execSQL(DROP_TABLE_SQL);
		onCreate(db);
	}

	private void initializeUsers(SQLiteDatabase db)
	{
		Log.d(LOG_TAG, "initializeStrings() : Hello");
		String[] names = context.getResources().getStringArray(R.array.names);
		ContentValues values = new ContentValues();
		db.beginTransaction();
		try
		{
			for (String name : names)
			{
				try
				{
					values.clear();
					values.put(Columns.NAME, name);
					values.put(Columns.EMAIL, name + "@example.com");
					db.insert(TABLE_NAME, null, values);
				}
				catch (IllegalArgumentException ex)
				{
					Log.e(LOG_TAG, "insert data failed.", ex);
				}
			}
			db.setTransactionSuccessful();
		}
		finally
		{
			db.endTransaction();
		}

		Log.d(LOG_TAG, "initializeStrings() : Bye");
	}
}
