/*
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.notification_hello;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Toast;

public class MainActivity extends Activity
	implements OnClickListener
{

	private static final int NOTIFICATION_ID_HELLO_SIMPLE = 1;
	private NotificationManager notificationManager;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		notificationManager = (NotificationManager) getSystemService(Activity.NOTIFICATION_SERVICE);

		Button notifyButton = (Button) findViewById(R.id.notify_button);
		notifyButton.setOnClickListener(this);

		Button notifyWithVibrate = (Button) findViewById(R.id.notify_with_vibrate_button);
		notifyWithVibrate.setOnClickListener(this);

		Button cancelButton = (Button) findViewById(R.id.cancel_button);
		cancelButton.setOnClickListener(this);

		Button cancelAllButton = (Button) findViewById(R.id.cancel_all_button);
		cancelAllButton.setOnClickListener(this);
	}

	@Override
	protected void onPause()
	{
		notificationManager.cancelAll();
		super.onPause();
	}

	public void onClick(View v)
	{
		switch (v.getId())
		{
			case R.id.notify_button:
				notifySimple();
				break;
			case R.id.notify_with_vibrate_button:
				notifyWithVibrate();
				break;
			case R.id.cancel_button:
				cancelSimpleNotification();
				break;
			case R.id.cancel_all_button:
				cancelAllNotification();
				break;
			default:
				throw new AssertionError();
		}
	}

	private void notifySimple()
	{
		// 通知をタップしたときに送信されるインテントを作成
		Intent intent = new Intent(this, HelloActivity.class);
		PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, intent, 0);

		// 通知したときにステータスバーに表示されるアイコンとテキストを設定
		Notification helloNotification = new Notification(
			android.R.drawable.ic_dialog_info,
			"Hello, simple nofitication",
			System.currentTimeMillis());

		// 通知画面を開いたときに表示されるイベントの内容を設定
		helloNotification.setLatestEventInfo(this,
			"Simple Event Title",
			"Simple Event Text",
			pendingIntent);
		notificationManager.notify(NOTIFICATION_ID_HELLO_SIMPLE, helloNotification);
	}

	private void notifyWithVibrate()
	{
		// 通知をタップしたときに送信されるインテントを作成
		Intent intent = new Intent(this, HelloActivity.class);
		PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, intent, 0);

		// 通知したときにステータスバーに表示されるアイコンとテキストを設定
		Notification helloNotification = new Notification(
			android.R.drawable.stat_notify_more,
			"Nofity with vibration",
			System.currentTimeMillis());

		// 通知画面を開いたときに表示されるイベントの内容を設定
		helloNotification.setLatestEventInfo(this,
			"Vibration Event Title",
			"Vibration Event Text",
			pendingIntent);

		// 通知時に振動をするように設定
		helloNotification.defaults = helloNotification.defaults | Notification.DEFAULT_VIBRATE;

		notificationManager.notify(NOTIFICATION_ID_HELLO_SIMPLE, helloNotification);
	}

	private void cancelSimpleNotification()
	{
		Toast.makeText(this, R.string.cancel, Toast.LENGTH_SHORT).show();
		notificationManager.cancel(NOTIFICATION_ID_HELLO_SIMPLE);
	}

	private void cancelAllNotification()
	{
		Toast.makeText(this, R.string.cancel_all, Toast.LENGTH_SHORT).show();
		notificationManager.cancelAll();
	}
}
