/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.example.hello.android.preference_custom_dialog;

import android.content.Context;
import android.content.res.TypedArray;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;

/**
 *
 * @author sawai
 */
public class NameEditPreference extends DialogPreference
{

	private static final String LOG_TAG = "XXX";
	private EditText firstNameEditText;
	private EditText lastNameEditText;
	private String name;

	public NameEditPreference(Context context, AttributeSet attrs, int defStyle)
	{
		super(context, attrs, defStyle);
	}

	public NameEditPreference(Context context, AttributeSet attrs)
	{
		super(context, attrs);
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		Log.v(LOG_TAG, "setName() : Hello");
		this.name = name;
		persistString(name);
		Log.v(LOG_TAG, "setName() : Hello");
	}

	@Override
	protected View onCreateDialogView()
	{
		Log.v(LOG_TAG, "onCreateDialogView() : Hello");

		LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View contentView = inflater.inflate(R.layout.name_edit_dialog, null);
		firstNameEditText = (EditText) contentView.findViewById(R.id.first_name_edittext);
		lastNameEditText = (EditText) contentView.findViewById(R.id.last_name_edittext);

		// load from preferences
		String nameString = getPersistedString("");
		String[] split = nameString.split(",", 2);
		if (split.length == 2)
		{
			firstNameEditText.setText(split[0].trim());
			lastNameEditText.setText(split[1].trim());
		}

		Log.v(LOG_TAG, "onCreateDialogView() : Bye");
		return contentView;
	}

	@Override
	protected void onDialogClosed(boolean positiveResult)
	{
		Log.v(LOG_TAG, "onDialogClosed() : Hello");

		if (positiveResult)
		{
			// save to preferences
			String firstName = firstNameEditText.getText().toString();
			String lastName = lastNameEditText.getText().toString();
			String fullName = firstName + ", " + lastName;
			if (callChangeListener(fullName))
			{
				setName(fullName);
			}
		}
		super.onDialogClosed(positiveResult);

		Log.v(LOG_TAG, "onDialogClosed() : Hello");
	}

	@Override
	protected void onSetInitialValue(boolean restorePersistedValue, Object defaultValue)
	{
		Log.v(LOG_TAG, "onSetInitialValue() : Hello");
		Log.v(LOG_TAG, "onSetInitialValue() : restorePersistedValue => " + restorePersistedValue);
		Log.v(LOG_TAG, "onSetInitialValue() : defaultValue => " + defaultValue);
		setName(restorePersistedValue ? getPersistedString(this.name) : (String) defaultValue);
		Log.v(LOG_TAG, "onSetInitialValue() : Bye");
	}

	@Override
	protected Object onGetDefaultValue(TypedArray a, int index)
	{
		String defaultValue = a.getString(index);
		Log.v(LOG_TAG, "onGetDefaultValue() : Hello");
		Log.d(LOG_TAG, "onGetDefaultValue() : a.getString(index) => " + a.getString(index));

		Log.v(LOG_TAG, "onGetDefaultValue() : Bye");
		return defaultValue;
	}
}
