/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.ui_pattern_listview_crud_array;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class UserDetailViewActivity extends Activity
	implements View.OnClickListener, UserConstants
{

	private static final String LOG_TAG = "XXX";

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate(savedInstanceState);

		Intent intent = getIntent();
		setContentView(R.layout.user_detail_view_activity);

		// Bind view values
		UserDetailUtils.loadValuesFromIntent(this, intent);

		// Setup listeners
		Button editButton = (Button) findViewById(R.id.edit_button);
		editButton.setOnClickListener(this);

		TextView emailTextView = (TextView) findViewById(R.id.email_textview);
		emailTextView.setOnClickListener(this);

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	public void onClick(View view)
	{
		Log.v(LOG_TAG, "onClick() : Hello");
		switch (view.getId())
		{
			case R.id.email_textview:
				startSendToEmailActivity();
				break;
			case R.id.edit_button:
				Log.d(LOG_TAG, "onClick() : editButton is clicked.");
				startEditUserActivity();
		}

		Log.v(LOG_TAG, "onClick() : Bye");
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		Log.v(LOG_TAG, "onActivityResult() : Hello");
		if (requestCode == REQUEST_CODE_EDIT_USER && resultCode == RESULT_OK)
		{
			Log.d(LOG_TAG, "onActivityResult() : User edit is done.");
			int id = data.getIntExtra(UserDetailViewActivity.EXTRA_ID, -1);
			if (id != -1)
			{
				UserDetailUtils.loadValuesFromIntent(this, data);
			}
			setResult(RESULT_OK, data);
		}
		Log.v(LOG_TAG, "onActivityResult() : Bye");
	}

	private void startEditUserActivity()
	{
		Log.v(LOG_TAG, "startEditUserActivity() : Hello");

		Intent intent = new Intent(this, UserDetailEditActivity.class);
		intent.setAction(Intent.ACTION_EDIT);
		UserDetailUtils.saveValuesToIntent(this, intent);
		startActivityForResult(intent, REQUEST_CODE_EDIT_USER);

		Log.v(LOG_TAG, "startEditUserActivity() : Bye");
	}

	private void startSendToEmailActivity()
	{
		Log.v(LOG_TAG, "startSendToEmailActivity() : Hello");

		TextView emailTextView = (TextView) findViewById(R.id.email_textview);
		CharSequence text = emailTextView.getText();
		if (TextUtils.isEmpty(text) == false)
		{
			Uri emailUri = Uri.parse("mailto:" + text);
			Log.d(LOG_TAG, "startSendToEmailActivity() : emailUri => " + emailUri);
			Intent intent = new Intent(Intent.ACTION_SENDTO, emailUri);
			startActivity(intent);
		}

		Log.v(LOG_TAG, "startSendToEmailActivity() : Bye");
	}
}
