/*
 *  The MIT License
 * 
 *  Copyright 2011,2013 Masahiko, SAWAI <say@users.sourceforge.jp>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package com.example.hello.android.wifi_state_receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

/**
 *
 * @author Masahiko, SAWAI <say@users.sourceforge.jp>
 */
public class WifiStateLoggingReceiver extends BroadcastReceiver
{

	private static final String LOG_TAG = "XXX";

	@Override
	public void onReceive(Context cntxt, Intent intent)
	{
		Log.d(LOG_TAG, "WifiStateChangedReceiver#onReceive() Hello");

		Bundle extras = intent.getExtras();
		for (String key : extras.keySet())
		{
			Log.d(LOG_TAG, String.format("extras %s -> %s ", key, extras.get(key)));
		}
		int previous = extras.getInt(WifiManager.EXTRA_PREVIOUS_WIFI_STATE);
		int current = extras.getInt(WifiManager.EXTRA_WIFI_STATE);
		Toast.makeText(cntxt, "WifiStateChangedReceiver : " + previous + " -> " + current, Toast.LENGTH_SHORT).show();

		Log.d(LOG_TAG, "WifiStateChangedReceiver#onReceive() Bye");
	}
}
