/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import twitter4j.RelatedResults;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RelatedResultsJSONImpl
extends TwitterResponseImpl
implements RelatedResults,
Serializable {
    private static final String TWEETS_WITH_CONVERSATION = "TweetsWithConversation";
    private static final String TWEETS_WITH_REPLY = "TweetsWithReply";
    private static final String TWEETS_FROM_USER = "TweetsFromUser";
    private static final long serialVersionUID = -7417061781993004083L;
    private Map<String, ResponseList<Status>> tweetsMap;

    RelatedResultsJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        DataObjectFactoryUtil.clearThreadLocalMap();
        JSONArray jsonArray = res.asJSONArray();
        this.init(jsonArray, res, true);
    }

    RelatedResultsJSONImpl(JSONArray jsonArray) throws TwitterException {
        this.init(jsonArray, null, false);
    }

    private void init(JSONArray jsonArray, HttpResponse res, boolean registerRawJSON) throws TwitterException {
        this.tweetsMap = new HashMap<String, ResponseList<Status>>(2);
        try {
            int listLen = jsonArray.length();
            for (int i = 0; i < listLen; ++i) {
                String groupName;
                JSONObject o = jsonArray.getJSONObject(i);
                if (!"Tweet".equals(o.getString("resultType")) || (groupName = o.getString("groupName")).length() == 0 || !groupName.equals(TWEETS_WITH_CONVERSATION) && !groupName.equals(TWEETS_WITH_REPLY) && !groupName.equals(TWEETS_FROM_USER)) continue;
                JSONArray results = o.getJSONArray("results");
                ResponseList<Status> statuses = this.tweetsMap.get(groupName);
                if (statuses == null) {
                    statuses = new ResponseListImpl<Status>(results.length(), res);
                    this.tweetsMap.put(groupName, statuses);
                }
                int resultsLen = results.length();
                for (int j = 0; j < resultsLen; ++j) {
                    JSONObject json = results.getJSONObject(j).getJSONObject("value");
                    StatusJSONImpl status = new StatusJSONImpl(json);
                    if (registerRawJSON) {
                        DataObjectFactoryUtil.registerJSONObject(status, json);
                    }
                    statuses.add(status);
                }
                if (!registerRawJSON) continue;
                DataObjectFactoryUtil.registerJSONObject(statuses, results);
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public ResponseList<Status> getTweetsWithConversation() {
        ResponseList<Status> statuses = this.tweetsMap.get(TWEETS_WITH_CONVERSATION);
        if (null != statuses) {
            return statuses;
        }
        return new ResponseListImpl<Status>(0, null);
    }

    @Override
    public ResponseList<Status> getTweetsWithReply() {
        ResponseList<Status> statuses = this.tweetsMap.get(TWEETS_WITH_REPLY);
        if (null != statuses) {
            return statuses;
        }
        return new ResponseListImpl<Status>(0, null);
    }

    @Override
    public ResponseList<Status> getTweetsFromUser() {
        ResponseList<Status> statuses = this.tweetsMap.get(TWEETS_FROM_USER);
        if (null != statuses) {
            return statuses;
        }
        return new ResponseListImpl<Status>(0, null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this.tweetsMap).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelatedResultsJSONImpl) {
            RelatedResultsJSONImpl other = (RelatedResultsJSONImpl)obj;
            return !(this.tweetsMap == null ? other.tweetsMap != null : !((Object)this.tweetsMap).equals(other.tweetsMap));
        }
        return false;
    }

    public String toString() {
        return new StringBuffer().append("RelatedResultsJSONImpl {tweetsMap=").append(this.tweetsMap).append("}").toString();
    }
}

