/*
 * Copyright (C) 2009 The Android Open Source Project
 * Copyright (C) 2010 Sony Ericsson Mobile Communications AB. All rights reserved.
 * This file contains confidential and proprietary information of Sony Ericsson
 * Mobile Communications AB.
 *
 * Original code licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 *
 * NOTE: This file has been modified by Sony Ericsson Mobile Communications AB.
 * Modifications are licensed under the Sony Ericsson Mobile Communications AB's
 * End User License Agreement ("EULA"). Any use of the modifications is subject
 * to the terms of the EULA.
 */

#ifndef FILE_SOURCE_H_

#define FILE_SOURCE_H_

#include <stdio.h>

#include <media/stagefright/DataSource.h>
#include <media/stagefright/MediaErrors.h>
#include <utils/threads.h>
/*Open DRM Framework change start*/
/*End of life for the patch is until the changes from Google
  are officially integrated to next release. Code is already
  in the AOSP master branch for review.
  https://review.source.android.com/#change,16142*/
#include <drm/DrmManagerClient.h>
/*Open DRM Framework change end*/

namespace android {

class FileSource : public DataSource {
public:
    FileSource(const char *filename);
    FileSource(int fd, int64_t offset, int64_t length);

    virtual status_t initCheck() const;

    virtual ssize_t readAt(off_t offset, void *data, size_t size);

    virtual status_t getSize(off_t *size);

/*Open DRM Framework change start*/
/*End of life for the patch is until the changes from Google
  are officially integrated to next release. Code is already
  in the AOSP master branch for review.
  https://review.source.android.com/#change,16142*/
    virtual sp<DecryptHandle> DrmInitialization(DrmManagerClient *client);

    virtual void getDrmInfo(sp<DecryptHandle> &handle, DrmManagerClient **client);
/*Open DRM Framework change end*/

protected:
    virtual ~FileSource();

private:
    FILE *mFile;
/*Open DRM Framework change start*/
/*End of life for the patch is until the changes from Google
  are officially integrated to next release. Code is already
  in the AOSP master branch for review.
  https://review.source.android.com/#change,16142*/
    int mFd;
/*Open DRM Framework change end*/
    int64_t mOffset;
    int64_t mLength;
    Mutex mLock;

/*Open DRM Framework change start*/
/*End of life for the patch is until the changes from Google
  are officially integrated to next release. Code is already
  in the AOSP master branch for review.
  https://review.source.android.com/#change,16142*/
    DrmManagerClient *mDrmManagerClient;
    sp<DecryptHandle> mDecryptHandle;
/*Open DRM Framework change end*/

/*Open DRM Framework change start*/
/*End of life for the patch is until the changes from Google
  are officially integrated to next release. */
    /* Caching DRM calls */
    int64_t mDrmBufOffset;
    int64_t mDrmBufSize;
    unsigned char *mDrmBuf;
/*Open DRM Framework change end*/

    FileSource(const FileSource &);
    FileSource &operator=(const FileSource &);
};

}  // namespace android

#endif  // FILE_SOURCE_H_

