/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.facebookplugin;

import com.sonyericsson.eventstream.facebookplugin.EventStreamConstants.Config;

import android.util.Log;
import java.lang.reflect.Method;


public class CredentialHandler {

    final static String TAG = "CredentialHandler";

    /** Facebook application key */
    public static final int FACEBOOK_API_KEY = 1;

    /** Facebook secret key */
    public static final int FACEBOOK_SECRET_KEY = 2;

    /** This instance */
    private static CredentialHandler mInstance = null;

    /** The api key set to use */
    private String mApiKeySet = null;

    /** Timescape api key set system property */
    private static final String RO_SEMC_TIMESCAPE_KEYS = "ro.semc.timescape_keys";

    /** Emulator product model */
    private static final String EMULATOR_MODEL =  "sdk";

    /** SEMC emulator product model */
    private static final String SEMC_EMULATOR_MODEL =  "semcsdk";

    /** Emulator product model eDream */
    private static final String MANUFACTURER =  "Sony Ericsson";

    /*********************************************************************
     * Encrypted API keys
     *********************************************************************/

    /*
     * NOTE!
     * The API and Secret keys used are those used for Rachael. The keys for
     * Sony_Ericsson_XPeria and Sony_Ericsson_XPeria_PLAY does not work.
     * When logged in to Facebook they will be identified as Sony Ericsson X10.
     */

    /** Play product model */
    private static final String PLAY_PRODUCT_MODEL =  "Sony_Ericsson_Xperia_PLAY";

    /** Play product model Facebook api key */
    private static final String PLAY_PRODUCT_MODEL_FACEBOOK_API_KEY =
       "-49cb5bc234c08a7f0fa1d160de6ebf29357c2809b18e1ffe87081a8a71f8b3017e097e9168e35eee147cb5c457c52dbe";

    /** Play product model Facebook secret key */
    private static final String PLAY_PRODUCT_MODEL_FACEBOOK_SECRET_KEY =
      "-6dc2fce77b0c483b22d0e9975baa28790afa950b662004184005a93d39caffa87e097e9168e35eee147cb5c457c52dbe";


    /** Generic product model */
    private static final String GENERIC_PRODUCT_MODEL =  "Sony_Ericsson_Xperia";

    /** Generic product model Facebook api key */
    private static final String GENERIC_PRODUCT_MODEL_FACEBOOK_API_KEY =
     "-49cb5bc234c08a7f0fa1d160de6ebf29357c2809b18e1ffe87081a8a71f8b3017e097e9168e35eee147cb5c457c52dbe";

    /** Generic product model Facebook secret key */
    private static final String GENERIC_PRODUCT_MODEL_FACEBOOK_SECRET_KEY =
     "-6dc2fce77b0c483b22d0e9975baa28790afa950b662004184005a93d39caffa87e097e9168e35eee147cb5c457c52dbe";


    /** Developer product model */
    private static final String DEV_PRODUCT_MODEL =  "dev_key";

    /** Developer product model Facebook api key */
    private static final String DEV_FACEBOOK_API_KEY =
        "-3ebc29be90b409e40ffcde6f9be896703dbd31ec9266f98855b2a0b233786c2b7e097e9168e35eee147cb5c457c52dbe";

    /** Developer product Facebook secret key */
    private static final String DEV_FACEBOOK_SECRET_KEY =
        "6d6999ebb02b660c1649ac4e3f184bdd8ca3f2ae15061643f47529e3fb10a42081f6816e971ca111eb834a3ba83ad242";


    /**
     * List of all supported api keys in the format {model,
     * facebook api key, facebook secret key}
     */
    private static final String[][] mApiKeys = {
        {
                DEV_PRODUCT_MODEL,
                DEV_FACEBOOK_API_KEY,
                DEV_FACEBOOK_SECRET_KEY
        },

        {
                PLAY_PRODUCT_MODEL,
                PLAY_PRODUCT_MODEL_FACEBOOK_API_KEY,
                PLAY_PRODUCT_MODEL_FACEBOOK_SECRET_KEY
        },

        {
                GENERIC_PRODUCT_MODEL,
                GENERIC_PRODUCT_MODEL_FACEBOOK_API_KEY,
                GENERIC_PRODUCT_MODEL_FACEBOOK_SECRET_KEY
        }
    };

    /** System property method used by reflection */
    private static Method mSystemPropertiesGet = null;

    public static final int NOTIFY_ID = 1;

    /**
     * Default constructor, protected so the class can be extended (can be used
     * for mocking the class in test)
     */
    protected CredentialHandler() {

        try {
            Class<?> sysProp = Class.forName("android.os.SystemProperties");
            mSystemPropertiesGet = sysProp.getMethod("get", new Class[] { String.class } );
        } catch(Exception e) {
            if (Config.DEBUG) {
                Log.e(TAG, "Could not load the SystemProperties.get method");
            }
        }

        if (mSystemPropertiesGet != null) {
            try {
                mApiKeySet = (String) mSystemPropertiesGet.invoke(null, RO_SEMC_TIMESCAPE_KEYS);
            } catch(Exception e) {
                if (Config.DEBUG) {
                    Log.e(TAG, "Error, not possible to invoke system properties get");
                }
            }
        } else {
            if (Config.DEBUG) {
                Log.e(TAG, "Error, system properties get function is null");
            }
        }

        if (mApiKeySet == null || mApiKeySet.length() <= 0) {
            if (!android.os.Build.MANUFACTURER.equals(MANUFACTURER) &&
                !android.os.Build.MODEL.equals(EMULATOR_MODEL) &&
                !android.os.Build.MODEL.equals(SEMC_EMULATOR_MODEL) ) {
                throw new RuntimeException("System property keys not set");
            } else {
                mApiKeySet = DEV_PRODUCT_MODEL;
            }
        }
    }

    /**
     * Get an instance of this singleton.
     *
     * @return the instance of this class
     */
    public static CredentialHandler getInstance() {
        if (mInstance == null) {
            mInstance = new CredentialHandler();
        }

        return mInstance;
    }

    /**
     * Retrive an encryped api key.
     *
     * @param type sns type, valid values are
     *          FACEBOOK_API_KEY or FACEBOOK_SECRET_KEY
     * @return the encryped api key.
     * @throws IllegalArgumentException on invalid argument
     */
    public String getCredential(int type) {

        String result = null;

        for (int i = 0; i < mApiKeys.length; i++) {
            if (mApiKeys[i][0].equals(mApiKeySet)) {
                switch (type) {
                    case FACEBOOK_API_KEY:
                        result = mApiKeys[i][1];
                        break;
                    case FACEBOOK_SECRET_KEY:
                        result = mApiKeys[i][2];
                        break;
                    default:
                        throw new IllegalArgumentException("Invalid type:" + type);
                }
                break;
            }
        }

        if (result == null) {
            throw new IllegalArgumentException("Invalid sns type or api key set not declared. type:"
                    + type);
        }

        return result;
    }
}
