/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.simpleui.activity;

import com.sonyericsson.simpleui.R;
import com.sonyericsson.simpleui.activity.SimpleUiInternal.Config;
import com.sonyericsson.simpleui.provider.EventStreamContentProvider;
import com.sonyericsson.simpleui.utils.DBUtilities;
import com.sonyericsson.simpleui.utils.ImageDownloader;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.provider.ContactsContract.Contacts;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.AdapterView.OnItemClickListener;

public class SimpleUiEventsActivity extends Activity {

    private static final int EVENT_CLICKED_DIALOG = 1;

    private long mIdClicked;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Config.DEBUG) {
            Log.i(Config.LOG_TAG, "SimpleUi Events activity onCreate called");
        }
        setContentView(R.layout.events_listing);
        setupView();
    }

    private void setupView() {
        ListView eventsListView = (ListView)findViewById(R.id.eventsListView);

        Cursor c = DBUtilities.querySplineEventCursor(this, null);

        SimpleUiEventsAdapter eventsListAdapter = new SimpleUiEventsAdapter(this, c);
        eventsListView.setAdapter(eventsListAdapter);

        eventsListView.setOnItemClickListener(new OnItemClickListener() {
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (Config.DEBUG) {
                    Log.d(Config.LOG_TAG, "Clicked item position=" + position + ", id=" + id);
                }
                mIdClicked = id;
                showDialog(EVENT_CLICKED_DIALOG);
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ImageDownloader.cleanupCache();
        // FIXME How to purge ongoing image download tasks?
    }

    protected Dialog onCreateDialog(int id) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this);

        dialogBuilder.setTitle(R.string.simpleui_event_clicked_dialog_title);
        dialogBuilder.setItems(R.array.simpleui_event_dialog_options,
                new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int which) {
                        switch (which) {
                            case 0:
                                launchPreview();
                                break;
                            case 1:
                                launchActivityView();
                                break;
                            case 2:
                                launchInfiniteView();
                                break;
                        }
                    }
                });
        return dialogBuilder.create();
    }

    private void launchPreview() {
        Intent intent = new Intent(getApplication(), SimpleUiPreviewActivity.class);
        intent.putExtra(SimpleUiPreviewActivity.EVENT_ID_INTENT_DATA_KEY, mIdClicked);
        startActivity(intent);
    }

    private void launchActivityView() {
        Cursor c = null;
        Intent intent = new Intent(EventStreamContentProvider.OutgoingIntents.VIEW_EVENT_INTENT);
        Integer pluginId = null;
        try {
            c = DBUtilities.querySplineEventCursor(this, String.valueOf(mIdClicked));

            if (c != null && c.moveToFirst()) {
                int serviceId = c.getInt(c
                        .getColumnIndexOrThrow(EventStreamContentProvider.EventColumns.SOURCE_ID));
                intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_SOURCE_ID, serviceId);

                String friendKey = c.getString(c
                                .getColumnIndexOrThrow(EventStreamContentProvider.FriendColumns.FRIEND_KEY));

                intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_FRIEND_KEY, friendKey);

                String eventKey = c.getString(c
                        .getColumnIndexOrThrow(EventStreamContentProvider.EventColumns.EVENT_KEY));
                intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_EVENT_KEY, eventKey);

                intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_EVENT_ID, String.valueOf(mIdClicked));

                pluginId = c.getInt(c
                        .getColumnIndexOrThrow(EventStreamContentProvider.EventColumns.PLUGIN_ID));
            } else {
                // Should not happen
                Log.e(Config.LOG_TAG, "Clicked listitem but item not found in events table with id="
                        + mIdClicked);
            }
        } finally {
            if (c != null) {
                c.close();
            }
        }
        if (pluginId != null) {
            try {
                c = getContentResolver().query(EventStreamContentProvider.Uris.PLUGIN_URI,
                        new String[] {
                            EventStreamContentProvider.PluginColumns.PACKAGE_NAME,
                            EventStreamContentProvider.PluginColumns.PLUGIN_KEY
                        }, EventStreamContentProvider.ID_COLUMN + " = ?", new String[] {
                            String.valueOf(pluginId)
                        }, null);

                if (c != null && c.moveToFirst()) {
                    int packageNameIndex = c
                            .getColumnIndexOrThrow(EventStreamContentProvider.PluginColumns.PACKAGE_NAME);
                    String packageName = c.getString(packageNameIndex);
                    intent.setPackage(packageName);

                    String pluginKey = c
                        .getString(c
                            .getColumnIndexOrThrow(EventStreamContentProvider.PluginColumns.PLUGIN_KEY));
                    if (pluginKey != null && !pluginKey.equals("")) {
                        intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_PLUGIN_KEY, pluginKey);
                    }

                    sendBroadcast(intent);
                }
            } finally {
                if (c != null) {
                    c.close();
                }
            }
        }
    }

    private void launchInfiniteView() {

        PackageManager pm = getPackageManager();
        Intent infiniteIntent = new Intent(
                EventStreamContentProvider.OutgoingIntents.INFINITE_VIEW_ACTION);
        ResolveInfo resolveInfo = pm.resolveActivity(infiniteIntent, 0);
        boolean hasInfiniteViewInstalled = false;
        if (resolveInfo != null) {
            hasInfiniteViewInstalled = true;
        }
        Cursor c = null;

        try {
            c = DBUtilities.querySplineEventCursor(this, String.valueOf(mIdClicked));

            if (c != null && c.moveToFirst()) {
                Intent intent = null;

                String friendKey = c
                    .getString(c
                        .getColumnIndexOrThrow(EventStreamContentProvider.EventColumns.FRIEND_KEY));

                if (hasInfiniteViewInstalled && friendKey != null) {
                    String sourceId = c
                            .getString(c
                                    .getColumnIndexOrThrow(EventStreamContentProvider.EventColumns.SOURCE_ID));
                    intent = new Intent(
                            EventStreamContentProvider.OutgoingIntents.INFINITE_VIEW_ACTION);
                    intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_FRIEND_KEY,
                            friendKey);
                    intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_SOURCE_ID,
                            sourceId);
                    try {

                        startActivity(intent);
                    } catch (ActivityNotFoundException e) {
                        Log.e(Config.LOG_TAG, "Activity not found, could not be started: " + e);
                    }

                } else if (friendKey != null) {
                    Cursor friendCursor = null;
                    try {
                        friendCursor = getContentResolver().query(
                                EventStreamContentProvider.Uris.FRIENDS_CONTENT_URI,
                                new String[] {
                                        EventStreamContentProvider.FriendColumns.CONTACTS_REFERENCE
                                }, EventStreamContentProvider.FriendColumns.FRIEND_KEY + " = ? ", new String[] {
                                        friendKey
                                }, null);
                        if (friendCursor != null && friendCursor.moveToFirst()) {
                            int columnIndex =
                                friendCursor.getColumnIndexOrThrow(EventStreamContentProvider.FriendColumns.CONTACTS_REFERENCE);
                            String contactReference = friendCursor.getString(columnIndex);
                            Uri contactUri = null;

                            if (contactReference != null && contactReference.startsWith(ContactsContract.RawContacts.CONTENT_URI.toString())) {
                                contactUri = getContactUriFromRawContact(contactReference);
                            } else {
                                contactUri = Uri.parse(contactReference);
                            }

                            if (contactUri != null) {
                                intent = new Intent(Intent.ACTION_VIEW);
                                intent.setData(contactUri);
                                try {
                                    startActivity(intent);
                                } catch (ActivityNotFoundException e) {
                                    Log.e(Config.LOG_TAG, "Activity not found, could not be started: " + e);
                                }
                            }
                        }
                    } finally {
                        if (friendCursor != null) {
                            friendCursor.close();
                        }
                    }
                }
            } else {
                // Should not happen
                Log.e(Config.LOG_TAG, "Clicked listitem but item not found in events table with id="
                        + mIdClicked);
            }
        } finally {
            if (c != null) {
                c.close();
            }
        }
    }

    protected Uri getContactUriFromRawContact(String rawContactUri) {
        return DBUtilities.getContactUri(getApplicationContext(), rawContactUri);
    }
}
