/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.simpleui.provider;

import android.net.Uri;

/**
 * Utility class to contain the constants defined by the Event Stream
 * content provider interface.
 *
 */
public interface EventStreamContentProvider {

    public static final String LEGACY_WRAPPER_PACKAGE = "com.sonyericsson.eventstream.legacywrapper";

    public static final class Uris {
        public static final String ONLINE_IMAGE_CACHE_PATH = "images";
        public static final String ONLINE_IMAGE_URI_QUERY_PARAM = "imageUri";
        public static final String AUTHORITY = "com.sonyericsson.eventstream";
        public static final Uri BASE_URI = Uri.parse("content://" + AUTHORITY);
        public static final Uri EVENTS_CONTENT_URI = Uri.withAppendedPath(BASE_URI, "events");
        public static final Uri FRIENDS_CONTENT_URI = Uri.withAppendedPath(BASE_URI, "friends");
        public static final Uri VIEWS_PATH_URI = Uri.withAppendedPath(BASE_URI, "views");
        public static final Uri INFINITE_VIEW_URI = Uri.withAppendedPath(VIEWS_PATH_URI, "infinite");
        public static final Uri PLUGIN_URI = Uri.withAppendedPath(BASE_URI, "plugins");
        public static final Uri SOURCE_URI = Uri.withAppendedPath(BASE_URI, "sources");
        public static final Uri IMAGE_CACHE_URI = Uri.withAppendedPath(BASE_URI, "images");
    }

    public static final class Tables {
        public static final String SOURCE_TABLE_NAME = "source";
    }

    public static final String ID_COLUMN = "_id";

    public static final class PluginColumns {
        public static final String API_VERSION = "api_version";
        public static final String CONFIGURATION_STATE = "config_state";
        public static final String CONFIGURATION_ACTIVITY = "config_activity";
        public static final String CONFIGURATION_TEXT = "config_text";
        public static final String NAME = "name";
        public static final String ICON_URI = "icon_uri";
        public static final String STATUS_SUPPORT = "status_support";
        public static final String PACKAGE_NAME = "package";
        public static final String UID_NAME = "uid_name";
        public static final String PLUGIN_KEY = "plugin_key";
    }

    public static final class SourceColumns {
        public static final String PLUGIN_ID = "plugin_id";
        public static final String NAME = "name";
        public static final String ICON_URI = "icon_uri";
        public static final String ENABLED = "enabled";
        public static final String CURRENT_STATUS = "current_status";
    }

    public static final class EventColumns {
        public static final String SOURCE_ID = "source_id";
        public static final String PLUGIN_ID = "plugin_id";
        public static final String FRIEND_KEY = "friend_key";
        public static final String MESSAGE = "message";
        public static final String IMAGE_URI = "image_uri";
        public static final String PUBLISHED_TIME = "published_time";
        public static final String STATUS_ICON_URI = "status_icon_uri";
        public static final String GEODATA = "geodata";
        public static final String TITLE = "title";
        public static final String PERSONAL = "personal";
        public static final String OUTGOING = "outgoing";
        public static final String EVENT_KEY = "event_key";
        public static final String DISPLAY_NAME = "display_name";
        public static final String HANDLED_TYPE = "handled_type";
    }

    public static final class EventFriendColumn {
        public static final String FRIEND_ID = "friend_id";
    }

    public static final class FriendColumns {
        public static final String SOURCE_ID = "source_id";
        public static final String PLUGIN_ID = "plugin_id";
        public static final String DISPLAY_NAME = "display_name";
        public static final String PROFILE_IMAGE_URI = "profile_image_uri";
        public static final String CONTACTS_REFERENCE = "contacts_reference";
        public static final String FRIEND_KEY = "friend_key";
    }

    public static final class OutgoingIntents {
        public static final String REGISTER_PLUGINS_REQUEST_INTENT = "com.sonyericsson.eventstream.REGISTER_PLUGINS";
        public static final String REFRESH_REQUEST_INTENT = "com.sonyericsson.eventstream.REFRESH_REQUEST";
        public static final String VIEW_EVENT_INTENT = "com.sonyericsson.eventstream.VIEW_EVENT_DETAIL";
        public static final String STATUS_UPDATE_INTENT = "com.sonyericsson.eventstream.SEND_STATUS_UPDATE";
        public static final String INFINITE_VIEW_ACTION = "com.sonyericsson.eventstream.INFINITE_VIEW_ACTION";
    }

    public static final class IntentData {
        public static final String EXTRA_SOURCE_ID = "source_id";
        public static final String EXTRA_EVENT_ID = "event_id";
        public static final String EXTRA_STATUS_UPDATE_MESSAGE = "new_status_message";
        public static final String EXTRA_CONTACTS_LOOKUP_KEY = "contacts_lookupkey";
        public static final String EXTRA_FRIEND_KEY = "friend_key";
        public static final String EXTRA_EVENT_KEY = "event_key";
        public static final String EXTRA_PACKAGENAME = "package_name";
        public static final String EXTRA_LEGACY_PACKAGE = "legacy_package";
        public static final String EXTRA_PLUGIN_KEY = "plugin_key";
    }

    public static final class ConfigState {
        public static final int CONFIGURED = 0;
        public static final int NOT_CONFIGURED = 1;
        public static final int CONFIGURATION_NOT_NEEDED = 2;
    }

    public static final class StatusSupport {
        public static final int HAS_SUPPORT_FALSE = 0;
        public static final int HAS_SUPPORT_TRUE = 1;
    }

    /**
     * Restricted column-definitions for the Event table.
     */
    public static final class RawQuery {
        public static final String AUTHORITY = "com.sonyericsson.eventstream";
        public static final Uri BASE_URI = Uri.parse("content://" + AUTHORITY);
        public static final String MIME_TYPE = "eventstream-rawquery";
        public static final String RAW_QUERY_PATH = "rawquery";
        public static final Uri URI = Uri.withAppendedPath(BASE_URI, RAW_QUERY_PATH);
    }
}
