package com.sonyericsson.eventstream.telephonyplugin;

import com.sonyericsson.eventstream.telephonyplugin.PluginConstants.Config;
import com.sonyericsson.eventstream.telephonyplugin.PluginConstants.Telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract.PhoneLookup;
import android.util.Log;

public class OriginatedSourceHelper {

    /** Type of content - SMS */
    public static final int MESSAGE_TYPE_SMS = 0;

    /** Type of content - MMS */
    public static final int MESSAGE_TYPE_MMS = 1;

    /**
     * Will look up a contact containing address
     *
     * @param address The address to look up.
     * @return Cursor if exist else null
     */
    public Cursor contactLookupAddress(Context context, String address) {
        if (context == null || address == null || address.length() == 0) {
            return null;
        }
        if (Config.DEBUG) {
            Log.d(Config.LOG_TAG, "Lookup address = " + address);
        }
        Uri phoneLookupUri = Uri.withAppendedPath(PhoneLookup.CONTENT_FILTER_URI, Uri
                .encode(address));

        ContentResolver resolver = context.getContentResolver();
        if (phoneLookupUri != null && resolver != null) {
            try {
                return resolver.query(phoneLookupUri, null, null, null, null);
            } catch (IllegalArgumentException e) {
                Log.e(Config.LOG_TAG, "IllegalArgumentException : phoneLookupUri = " + phoneLookupUri);
            }
        }
        return null;
    }

    /**
     * Will return messages from the source
     *
     * @param where if null content will be returned else add restriction
     * @return Cursor if exist else null
     */
    public Cursor getSourceMessages(Context context, String where) {
        if (context == null) {
            return null;
        }
        return context.getContentResolver().query(Telephony.TELEPHONY_SMS_URI,
                new String[] {
                    Telephony.Sms.COLUMN_ID,
                    Telephony.Sms.COLUMN_ADDRESS,
                    Telephony.Sms.COLUMN_BODY,
                    Telephony.Sms.COLUMN_DATE,
                    Telephony.Sms.COLUMN_TYPE,
                    }, where, null, null);
    }

    /**
     * Return the address from a source id
     *
     * @param smsId The id to check for the address
     * @return The address if exist for the id else null
     */
    public String getAddressFromSmsId(Context context, int smsId) {
        if (context == null) {
            return null;
        }

        String address = null;
        Cursor smsCursor = null;
        try {
            smsCursor = getSourceMessages(context, Telephony.Sms.COLUMN_ID + " = " + smsId);
            if (smsCursor != null && smsCursor.moveToFirst()) {
                address = smsCursor.getString(smsCursor
                        .getColumnIndexOrThrow(Telephony.Sms.COLUMN_ADDRESS));
            }
        } finally {
            if (smsCursor != null) {
                smsCursor.close();
            }
        }
        return address;
    }

    /**
     * Get the messages detailed text
     *
     * @return The text, will never return null
     */
    public String getMessageText(Cursor cursor, int messageType) {
        if (cursor == null) {
            return "";
        }

        switch (messageType) {
            // If MMS then the text should be the subject if it exists
            /**case MESSAGE_TYPE_MMS: {
                String subject = cursor.getString(cursor
                        .getColumnIndexOrThrow(Telephony.Mms.SUBJECT));
                int charset = (int)cursor.getLong(cursor
                        .getColumnIndexOrThrow(Telephony.Mms.SUBJECT_CHARSET));

                if (charset != CharacterSets.ANY_CHARSET) {
                    byte byteArray[] = null;
                    byteArray = PduPersister.getBytes(subject);
                    if (null != byteArray) {
                        subject = new EncodedStringValue(charset, byteArray).getString();
                    }
                }
                return subject;
            }*/

            case MESSAGE_TYPE_SMS:
                return cursor.getString(cursor.getColumnIndexOrThrow(Telephony.Sms.COLUMN_BODY));

            default:
                return "";
        }
    }
}
