/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.telephonyplugin;

import android.net.Uri;

/**
 * Constants in the telephony plug-in.
 */
public interface PluginConstants {

    /** Configurations in the event stream telephony plug-in */
    public static interface Config {
        /** Set to true if debug printouts should be shown */
        public static final boolean DEBUG = false;

        /** Log tag handled in the printouts */
        public static final String LOG_TAG = "TelephonyPlugin";

        /** Delay to handle frequent changes in content observers */
        public static final int ONCHANGE_DELAY = 1000;
    }

    /** Plug-in service intent values */
    public static interface ServiceIntentCmd {

        /** Indicate that this is a service intent */
        public static final String SERVICE_COMMAND_KEY = "SERVICE_COMMAND";

        /** Indicate the service of a event refresh intent */
        public static final String REFRESH_REQUEST = "REFRESH_EVENTS";

        /** Indicate the service of a plug-in registration intent */
        public static final String REGISTER_PLUGIN = "REGISTER_PLUGIN";

        /** Indicate the service of a view message intent */
        public static final String VIEW_EVENT = "VIEW_EVENT";

        /** Indicate the service of a friend refresh intent */
        public static final String UPDATE_FRIENDS = "UPDATE_FRIENDS";

        /** Indicate that the language locale has changed */
        public static final String LOCALE_CHANGED = "com.sonyericsson.eventstream.telephonyplugin.LOCALE_CHANGED";
    }

    /** Plug-in Layout Type constants*/
    public static interface LayoutType {
        //These values are directly mapped to the layouts provided by plugin for InfiniteView to use
       // and must match the name suffix of the layout XML-files.
        public static final String SENT= "sent";
        public static final String RECEIVED = "received";

    }

    /** Telephony constants */
    public static interface Telephony {

        public static final Uri TELEPHONY_SMS_URI = Uri
                .parse("content://sms");

        public static final Uri TELEPHONY_MMS_SMS_URI = Uri
                .parse("content://mms-sms");

        /** Salues for the table */
        public interface Sms {
            static final String COLUMN_ID = "_id";

            static final String COLUMN_ADDRESS = "address";

            static final String COLUMN_BODY = "body";

            static final String COLUMN_TYPE = "type";

            static final String COLUMN_DATE = "date";

            static final int MESSAGE_TYPE_INBOX = 1;

            static final int MESSAGE_TYPE_SENT = 2;
        }
    }
    /** Event stream constants needed to access the engine */
    public static interface EventStream {

        public static final int EVENTSTREAM_PLUGIN_VERSION = 1;

        public static final int EVENTSTREAM_CONFIGURATION_STATE = 2;

        public static final Uri EVENTSTREAM_FRIEND_PROVIDER_URI = Uri
                .parse("content://com.sonyericsson.eventstream/friends");

        public static final Uri EVENTSTREAM_EVENT_PROVIDER_URI = Uri
                .parse("content://com.sonyericsson.eventstream/events");

        public static final Uri EVENTSTREAM_SOURCES_PROVIDER_URI = Uri
                .parse("content://com.sonyericsson.eventstream/sources");

        public static final Uri EVENTSTREAM_PLUGIN_PROVIDER_URI = Uri
                .parse("content://com.sonyericsson.eventstream/plugins");

        public static final String REGISTER_PLUGINS_ACTION = "com.sonyericsson.eventstream.REGISTER_PLUGINS";

        public static final String REFRESH_REQUEST_ACTION = "com.sonyericsson.eventstream.REFRESH_REQUEST";

        public static final String VIEW_EVENT_ACTION = "com.sonyericsson.eventstream.VIEW_EVENT_DETAIL";

        public static final String EVENTSTREAM_VIEW_INTENT_FRIEND_KEY_DATA = "friend_key";

        /** Column values for the friend table */
        public interface FriendColumns {
            static final String _ID = "_id";

            static final String SOURCE_ID = "source_id";

            static final String DISPLAY_NAME = "display_name";

            static final String PROFILE_IMAGE_URI = "profile_image_uri";

            static final String CONTACTS_REFERENCE = "contacts_reference";

            static final String FRIEND_KEY = "friend_key";
        }

        /** Column values for the plug-in table */
        public interface PluginColumns {
            static final String API_VERSION = "api_version";

            static final String CONFIGURATION_STATE = "config_state";

            static final String NAME = "name";

            static final String ICON_URI = "icon_uri";
        }

        /** Column values for the source table */
        public interface SourceColumns {
            static final String _ID = "_id";

            static final String NAME = "name";

            static final String ICON_URI = "icon_uri";

            static final String ENABLED = "enabled";

            static final String LAYOUT_ORDER = "layout_order";
        }

        /** Column values for the event table */
        public interface EventColumns {
            static final String _ID = "_id";

            static final String SOURCE_ID = "source_id";

            static final String FRIEND_KEY = "friend_key";

            static final String MESSAGE = "message";

            static final String PUBLISHED_TIME = "published_time";

            static final String PERSONAL = "personal";

            static final String OUTGOING = "outgoing";

            static final String EVENT_KEY = "event_key";

            static final String ICON_URI = "status_icon_uri";

            static final String LAYOUT_TYPE = "layout_type";
        }
    }
}
