/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.telephonyplugin;

import com.sonyericsson.eventstream.telephonyplugin.PluginConstants.ServiceIntentCmd;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import junit.framework.Assert;

@RunWith(PowerMockRunner.class)
@PrepareForTest( {
        TelephonyPluginService.class,
        Context.class,
        Intent.class,
        ComponentName.class,
        Log.class,
        TelephonyPluginApplication.class
})
public class TelephonyPluginApplicationTests {

    private static final String PACKAGE_NAME = "com.sonyericsson.eventstream.telephonyplugin";

    private static final String CLASS_NAME = PACKAGE_NAME + ".TelephonyPluginService";

    @Test
    public void testOnConfigurationChanged() {

        PowerMock.suppress(Log.class.getMethods());

        Intent intent = PowerMock.createMock(Intent.class);
        PowerMock.mockStatic(TelephonyPluginService.class);
        ComponentName componentName = PowerMock.createMock(ComponentName.class);
        TelephonyPluginApplication app = PowerMock.createPartialMock(TelephonyPluginApplication.class, "startService", "getPackageName");

        try {
            PowerMock.expectNew(Intent.class).andReturn(intent).once();
        } catch (Exception e) {
            Assert.fail("Could not create Intent class: " + e.getMessage());
        }
        EasyMock.expect(intent.putExtra(ServiceIntentCmd.SERVICE_COMMAND_KEY,
                ServiceIntentCmd.CONFIGURATION_CHANGED)).andReturn(intent).once();
        EasyMock.expect(app.getPackageName()).andReturn(PACKAGE_NAME).once();
        EasyMock.expect(TelephonyPluginService.class.getName()).andReturn(CLASS_NAME).once();
        try {
            PowerMock.expectNew(ComponentName.class, PACKAGE_NAME, CLASS_NAME).andReturn(componentName).once();
        } catch (Exception e) {
            Assert.fail("Could not create ComponentName class: " + e.getMessage());
        }

        EasyMock.expect(intent.setComponent(componentName)).andReturn(intent).once();
        EasyMock.expect(app.startService(intent)).andReturn(componentName).once();
        PowerMock.replayAll();
        app.startConfigurationChangedService();
        PowerMock.verifyAll();
    }
}
