/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin.twitter;

import android.util.Log;

import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;
import twitter4j.http.AccessToken;

import com.sonyericsson.eventstream.twitterplugin.PluginConstants.Config;

public class TwitterFactoryWrapper {

    /** Holds the instance of the Twitter factory */
    private TwitterFactory mFactory;

    /**
     * Will create a wrapper to a twitter factory with configuration
     */
    public TwitterFactoryWrapper(Configuration configuration) {
        mFactory = new TwitterFactory(configuration);
    }

    /**
     * Will create a wrapper to a twitter factory with default configuration
     */
    public TwitterFactoryWrapper() {
        mFactory = new TwitterFactory();
    }

    /**
     * See twitter4j.TwitterFactory
     */
    public Twitter getInstance(String screenName, String password) throws TwitterException {
        Twitter twitter = mFactory.getInstance(screenName, password);
        if (twitter == null) {
            Log.e(Config.LOG_TAG, "Twitter returned null during getInstance");
            throw new TwitterException("", new IllegalStateException(), TwitterException.UNAUTHORIZED);
        }
        return twitter;
    }

    /**
     * See twitter4j.TwitterFactory
     */
    public Twitter getOAuthAuthorizedInstance(AccessToken accessToken) throws TwitterException {
        Twitter twitter = mFactory.getInstance(accessToken);
        if (twitter == null) {
            Log.e(Config.LOG_TAG, "Twitter returned null during getOathInstance");
            throw new TwitterException("", new IllegalStateException(), TwitterException.UNAUTHORIZED);
        }
        return twitter;
    }
}
