/***************************************************************************/
/** @file       image_board.cpp
    @brief      drawing the board-polygon with texture
    @author     shom
****************************************************************************/

#include "pch_core.h"

#include "image_board.h"

#ifdef DX

#include "core/graphic/render_dx.h"

#else	//if GL

#include "core/glpng/glpng.h"

#endif


/***************************************************************************
	csequence_title
****************************************************************************/

cimage_board::cimage_board()
:
m_idx_texture_active( U32_INVALID )
#ifdef DX
,m_p_texture_list()//,
#endif
{
}

cimage_board::~cimage_board()
{
	release_all();

	cboard::~cboard();
}

void	cimage_board::release_all()
{
#ifdef DX
	///--
	p_texture_list_t::iterator it = m_p_texture_list.begin();
	const p_texture_list_t::iterator it_end = m_p_texture_list.end();

	while( it != it_end )
	{
		my_safe_rel( *it );

		++it;
	}
	///--
#endif
}

b32		cimage_board::Initialize()
{
	return ( cboard::Initialize() );
}

b32		cimage_board::Initialize(
	const TCHAR* const sz_path_texture,
	f32 width, f32 height
	)
{
	const b32 b_success = Initialize();
	
	if( b_success )
	{
		const u32 idx = CreateTexture( sz_path_texture, width, height );
		SetTextureActive( idx );
	}

	return b_success;
}

void	cimage_board::Finalize()
{
	cboard::Finalize();
}

void	cimage_board::Draw()
{
#ifdef DX
	///--
	if( m_idx_texture_active != U32_INVALID )
	{
		///--	reset info and setting
		LPDIRECT3DDEVICE9 p_device = g_p_render->GetDevice();
	
		//--
		ASSERT( m_p_texture_list[ m_idx_texture_active ] );
		p_device->SetTexture( 0, m_p_texture_list[ m_idx_texture_active ] );
		//--
	
		//--
		#define STSS p_device->SetTextureStageState
	
		STSS( 0	, D3DTSS_COLORARG1	, D3DTA_TEXTURE		);
		STSS( 0	, D3DTSS_COLORARG2	, D3DTA_DIFFUSE		);
		STSS( 0	, D3DTSS_COLOROP	, D3DTOP_MODULATE	);
		STSS( 0	, D3DTSS_ALPHAARG1	, D3DTA_TEXTURE		);
		STSS( 0	, D3DTSS_ALPHAARG2	, D3DTA_DIFFUSE		);
		STSS( 0	, D3DTSS_ALPHAOP	, D3DTOP_MODULATE	);
	
		#undef STSS
		//--
	
		//--	
		#define SRS p_device->SetRenderState
	
		SRS( D3DRS_ALPHABLENDENABLE	, TRUE					);
		SRS( D3DRS_SRCBLEND			, D3DBLEND_SRCALPHA		);
		SRS( D3DRS_DESTBLEND		, D3DBLEND_INVSRCALPHA	);
	
		#undef SRS
		//--
	}
	///--

	///--	draw
	cboard::Draw();
	///--
#else
	glBindTexture( GL_TEXTURE_2D, m_idx_texture_active );

	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
	glEnable( GL_BLEND );

	//glEnable( GL_TEXTURE_2D );
	glBegin( GL_QUADS );
	{		
#if 1
		for( u32 i=0; i<4; ++i )
		{
			glTexCoord2d( m_vertex_tbl[i].u, m_vertex_tbl[i].v );
			glVertex2f( m_vertex_tbl[i].x, m_vertex_tbl[i].y );
		}
#else
		glTexCoord2d( 1.0, 1.0 );
		glVertex2f( 0.5f, -0.5f );

		glTexCoord2d( 1.0, 0.0 );
		glVertex2f( 0.5f, 0.5f );

		glTexCoord2d( 0.0, 0.0 );
		glVertex2f( -0.5f, 0.5f );

		glTexCoord2d( 0.0, 1.0 );
		glVertex2f( -0.5f, -0.5f );
#endif
	}
	glEnd();
	//glDisable( GL_TEXTURE_2D );

	glDisable( GL_BLEND );
#endif
}

u32		cimage_board::CreateTexture(
	const TCHAR* const sz_path_texture,
	f32 width, f32 height
	)
{
	UNUSED( width );
	UNUSED( height );

#ifdef DX
	///--
	const u32 idx = m_p_texture_list.size();
	///--

	///--
	LPDIRECT3DTEXTURE9 p_texture_create;
	D3DXCreateTextureFromFileEx(
		g_p_render->GetDevice(),
		sz_path_texture,
#if 1
		D3DX_DEFAULT/*get from texture*/,	//Width
		D3DX_DEFAULT/*get from texture*/,	//Height
#else
		(UINT)width,	//Width
		(UINT)height,	//Height
#endif
		1,									//MipLevels
		0/*not special*/,					//Usage	
		D3DFMT_UNKNOWN/*get from texture*/,	//Format
		D3DPOOL_DEFAULT,
		D3DX_DEFAULT,						//Filter
		D3DX_DEFAULT,						//MipFilter
		0/*invalidate*/,					//ColorKey
		NULL, NULL,
		&( p_texture_create )
		);

	m_p_texture_list.push_back( p_texture_create );
	///--
#else	//if GL
	///--
	pngInfo info;

	char sz_temp[256];
	sprintf_s( sz_temp, "%S", sz_path_texture );

	const u32 tex_name = pngBind(
		sz_temp, PNG_NOMIPMAP, PNG_ALPHA, 
		&info, GL_CLAMP, GL_NEAREST, GL_NEAREST
		);
	///--
#endif

	///--
	SetSize( vec2f( width, height ) );
	///--

#ifdef DX
	return idx;
#else	//if GL
	return tex_name;
#endif
}

void	cimage_board::SetTextureActive( u32 idx )
{
	m_idx_texture_active = idx;
}

