/***************************************************************************/
/** @file       input_mouse.cpp
    @brief      
    @author     shom
    @internal
----------------------------------------------------------------------------
    $id
****************************************************************************/

#include "pch_core.h"

#include "input_mouse.h"

#include "raw/input_raw_mouse.h"


using namespace input_mouse_def;


/***************************************************************************
	cinput_mouse
****************************************************************************/

cinput_mouse::cinput_mouse(
#ifdef DX
	LPDIRECTINPUT8 p_dinput
#endif
	)
:
m_state_prev( FALSE ),
m_state_cur( FALSE ),

m_v2_pos_cur()//,
{
#ifdef DX
	m_p_input_raw = new cinput_raw_mouse( p_dinput );
#else	//elif GL
	m_p_input_raw = new cinput_raw_mouse();
#endif
}

void	cinput_mouse::Update()
{
	if( !m_p_input_raw )
	{
		return;
	}

	///--
	vec2f pos; my_memzero( &pos, sizeof( pos ) );
	u32 state = 0;

	const b32 b_success =
		RCAST<cinput_raw_mouse*>( m_p_input_raw )->GetState( pos, state );

	if( !b_success ) { return; }
	///--

	///--
	m_state_prev = m_state_cur;
	m_state_cur	 = state;

	m_v2_pos_cur	 = pos;
	///--
}

b32		cinput_mouse::IsPush( eMOUSE_BUTTON e_button )	const
{
	return ( is_prev_off( e_button ) && IsPushing( e_button ) );
}

b32		cinput_mouse::IsPull( eMOUSE_BUTTON e_button )	const
{
	return ( is_prev_on( e_button ) && !( IsPushing( e_button ) ) );
}

b32		cinput_mouse::is_prev_on( eMOUSE_BUTTON e_button )	const
{
	return ( ( m_state_prev & ( 1 << e_button ) ) != 0 );
}

b32		cinput_mouse::is_prev_off( eMOUSE_BUTTON e_button )	const
{
	return ( !( is_prev_on( e_button ) ) );
}

b32		cinput_mouse::IsPushing( eMOUSE_BUTTON e_button )	const
{
	return ( m_state_cur & ( 1 << e_button ) );
}

const vec2f&	cinput_mouse::GetPos()	const
{
	return m_v2_pos_cur;
}

b32		cinput_mouse::IsOnTheArea(
	const vec2f& v2_pos_area,
	const vec2f& v2_size_area
	)	const
{
	const vec2f v2_pos_mouse = GetPos();

	return 
		( ( v2_pos_area.x < v2_pos_mouse.x ) &&
		  ( v2_pos_mouse.x < v2_pos_area.x + v2_size_area.x ) ) &&
		( ( v2_pos_area.y < v2_pos_mouse.y ) &&
		  ( v2_pos_mouse.y < v2_pos_area.y + v2_size_area.y ) );
}

