/***************************************************************************/
/** @file       input_raw_mouse_gl.cpp
	@brief      L[{[ht
	@author     shom
	@internal
****************************************************************************/

#include "pch.h"

#include "input_raw_mouse.h"

#include "input/input_mouse_def.h"


using namespace input_mouse_def;


/***************************************************************************
	cinput_raw_mouse
****************************************************************************/

cinput_raw_mouse::cinput_raw_mouse()
:
cinput_raw_base()//,
{
}

/**
 * NX̊Jn
 */
b32		cinput_raw_mouse::Initialize()
{
	return ( cinput_raw_base::Initialize() );
}

void	cinput_raw_mouse::Finalize()
{
}

/**
 * }EX̏Ԃ擾
 * ͂F
 */
b32		cinput_raw_mouse::GetState( vec2f& out_pos, u32& out_state )
{
	UNUSED( out_pos );
	UNUSED( out_state );

	out_pos.x = SCAST<f32>( pos_x );
	out_pos.y = SCAST<f32>( pos_y );

	out_state = MOUSE_BUTTON_NONE;
	if( b_button_on_tbl[ eMOUSE_BUTTON_LEFT ] )
	{ out_state |= MOUSE_BUTTON_LEFT; }
	if( b_button_on_tbl[ eMOUSE_BUTTON_RIGHT ] )
	{ out_state |= MOUSE_BUTTON_RIGHT; }
	if( b_button_on_tbl[ eMOUSE_BUTTON_CENTER ] )
	{ out_state |= MOUSE_BUTTON_CENTER; }

	return TRUE;
}

b32	cinput_raw_mouse::b_button_on_tbl[] = {0};
u32 cinput_raw_mouse::pos_x = 0;
u32 cinput_raw_mouse::pos_y = 0;

void	cinput_raw_mouse::CallbackInput( int button, int state, int x, int y )
{
	const eMOUSE_BUTTON e_button =
		( button == GLUT_LEFT_BUTTON ) ? eMOUSE_BUTTON_LEFT :
		( button == GLUT_RIGHT_BUTTON ) ? eMOUSE_BUTTON_RIGHT :
		( button == GLUT_MIDDLE_BUTTON ) ? eMOUSE_BUTTON_CENTER :
		eMOUSE_BUTTON_INVALID;

	const b32 b_on_valid = ( state == GLUT_UP || state == GLUT_DOWN );
	const b32 b_on = ( state == GLUT_DOWN );

	if( ( e_button != eMOUSE_BUTTON_INVALID ) && b_on_valid )
	{
		b_button_on_tbl[ e_button ] = b_on;
	}

	pos_x = x;
	pos_y = y;
}
