//-----------------------------------------------------
//	DirectShowɂ鉹t@CĐTv
//	2010.01.05 TMO
//-----------------------------------------------------

#include "pch_core.h"
#include "ShowSound.h"

#pragma comment(lib,"strmiids.lib") 


CShowSound::CShowSound()
:
m_p_graph_builder( NULL ),
m_p_media_ctrl( NULL ),
m_p_media_pos( NULL ),

m_b_play( false ),
m_b_loop_mode( false )//,
{
}


CShowSound::~CShowSound()
{
	Release();
}


/**
 * t@C̓ǂݍ
 * 
 * @param file
 */
void CShowSound::LoadFile( BSTR file )
{
	CoInitialize( NULL );
	CoCreateInstance(
		CLSID_FilterGraph,
		NULL,
		CLSCTX_INPROC,
		IID_IGraphBuilder,
		reinterpret_cast<LPVOID*>( &m_p_graph_builder )
		);
	m_p_graph_builder->QueryInterface(
		IID_IMediaControl,
		reinterpret_cast<LPVOID*>( &m_p_media_ctrl )
		);
		
	m_p_graph_builder->QueryInterface(
		IID_IMediaPosition,
		reinterpret_cast<LPVOID*>( &m_p_media_pos )
		);
	
	m_p_media_ctrl->RenderFile( file );
}


/**
 * Đ
 */
void CShowSound::Play()
{
	//if( !IS_DEBUG_SWITCH( MUTE_BGM ) )
	{
		m_p_media_ctrl->Run();
		m_b_play		= true;
		m_b_loop_mode	= false;
	}
}


/**
 * [vĐ
 */
void CShowSound::PlayLoop()
{
//	if( !IS_DEBUG_SWITCH( MUTE_BGM ) )
	{
		m_p_media_ctrl->Run();
		m_b_play		= true;
		m_b_loop_mode	= true;
	}
}


void CShowSound::ChkLoop()
{
	if( m_b_play && m_b_loop_mode )
	{
		REFTIME pos, end;
		m_p_media_pos->get_CurrentPosition( &pos );
		m_p_media_pos->get_StopTime( &end );
		
		if( pos >= end )
		{	
			//̕@Ŗ߂ƊJnr؂Ă܂
			//m_p_media_pos->put_CurrentPosition(0);
			//m_p_media_ctrl->Run();
			
			//ł~߂ĂĐ
			Stop();
			PlayLoop();
		}
	}
}


/**
 * Đ̏ꍇł擪ɖ߂čĐ
 */
void CShowSound::PlayFromStart()
{
	m_p_media_pos->put_CurrentPosition(0);
	m_p_media_ctrl->Run();
	
	m_b_play = true;
}


/**
 * ꎞ~
 */
void CShowSound::Pause()
{
	m_p_media_ctrl->Pause();
	
	m_b_play = false;
}


/**
 * ~
 */
void CShowSound::Stop()
{
	m_p_media_ctrl->Stop();
	//Stop()łĐʒu擪ɖ߂Ȃ̂ŁAŖ߂
	m_p_media_pos->put_CurrentPosition(0);
	
	m_b_play = false;
}


/**
 * {[Abv
 */
void CShowSound::VolUp()
{
	IBasicAudio *p_basic_audio;
	m_p_graph_builder->QueryInterface(
		IID_IBasicAudio,
		reinterpret_cast<LPVOID*>( &p_basic_audio )
		);

	long vol = 0;
	p_basic_audio->get_Volume( &vol );
	vol += 100;
	if( vol > 0 )
	{
		vol = 0;
	}
	p_basic_audio->put_Volume(vol);

	p_basic_audio->Release();
}


/**
 * {[_E
 */
void CShowSound::VolDown()
{
	IBasicAudio*	p_basic_audio;
	m_p_graph_builder->QueryInterface(
		IID_IBasicAudio,
		reinterpret_cast<LPVOID*>( &p_basic_audio )
		);

	long vol = 0;
	p_basic_audio->get_Volume( &vol );
	vol -= 100;
	if( vol < -10000 )
	{
		vol = -10000;
	}
	p_basic_audio->put_Volume(vol);

	p_basic_audio->Release();
}


/**
 * \[X
 */
void CShowSound::Release()
{
	if( m_p_media_pos )
	{
		m_p_media_pos->Release();
		m_p_media_pos = NULL;
	}

	if( m_p_media_ctrl )
	{
		m_p_media_ctrl->Release();
		m_p_media_ctrl = NULL;
	}
	
	if( m_p_graph_builder )
	{
		m_p_graph_builder->Release();
		m_p_graph_builder = NULL;

		CoUninitialize();
	}
}