/***************************************************************************/
/** @file       mm_etc.cpp
    @brief      Zp֐
    @author     shom
****************************************************************************/

#include "pch_util.h"


/***************************************************************************
	mm( namespace )
****************************************************************************/

u32	mm::rand_i()
{
	return ( rand() );
}

s32 mm::sign_i( const s32 in_val )
{
	return ( in_val >= 0 ) ? 1 : -1;
}
f32 mm::sign_f( const f32 in_val )
{
	return ( in_val >= 0.0f ) ? 1.0f : -1.0f;
}

s32	mm::abs_i( const s32 in_val )
{
	return ( in_val * sign_i( in_val ) );
}
f32	mm::abs_f( const f32 in_val )
{
	return ( in_val * sign_f( in_val ) );
}

b32 mm::is_nearly_equal_i( const s32 a, const s32 b, const s32 tolerance )
{
	return ( abs_i( a - b ) < tolerance );
	
}
b32 mm::is_nearly_equal_f( const f32 a, const f32 b, const f32 tolerance )
{
	return ( abs_f( a - b ) < tolerance );

}

s32	mm::clamp_i( s32 in_iVal, s32 in_iMin, s32 in_iMax )
{
	return (
		( in_iVal < in_iMin ) ? in_iMin :
		( in_iVal > in_iMax ) ? in_iMax :
		in_iVal
		);
}

f32	mm::clamp_f( f32 in_fVal, f32 in_fMin, f32 in_fMax )
{
	return (
		( in_fVal < in_fMin ) ? in_fMin :
		( in_fVal > in_fMax ) ? in_fMax :
		in_fVal
		);
}

f32	mm::saturate( f32 in_fVal )
{
	return ( clamp_f( in_fVal, 0.f, 1.f ) );
}

s32 mm::min_i( s32 in_iVal1, s32 in_iVal2 )
{
	return ( ( in_iVal1 < in_iVal2 ) ? in_iVal1 : in_iVal2 );
}

f32 mm::min_f( f32 in_fVal1, f32 in_fVal2 )
{
	return ( ( in_fVal1 < in_fVal2 ) ? in_fVal1 : in_fVal2 );
}

s32 mm::max_i( s32 in_iVal1, s32 in_iVal2 )
{
	return ( ( in_iVal1 > in_iVal2 ) ? in_iVal1 : in_iVal2 );
}

f32 mm::max_f( f32 in_fVal1, f32 in_fVal2 )
{
	return ( ( in_fVal1 > in_fVal2 ) ? in_fVal1 : in_fVal2 );
}

