/***************************************************************************/
/** @file       debug_dip.cpp
    @brief      sfobOXCb`
    @author     shom
    @internal
****************************************************************************/

#include "pch_core.h"

#include "debug_dip.h"


using namespace debug_dip;


namespace
{
	///--	define
	b32 s_bDipOnOff_tbl[ eNof_DebugDipItem ] = {0};
	
	TCHAR* s_szDebugDipCategoryTbl[ eNof_DebugDipCategory ] =
	{
		/**-------------------------------------------------------------------**/
		#define DEBUG_DIP_CATEGORY( _name )	\
		\
		_T( #_name ),
		
		#include "core/debug/debug_dip/debug_dip_def.h"
		#undef DEBUG_DIP_CATEGORY
		/**-------------------------------------------------------------------**/
	};

	TCHAR* s_szDebugDipItemTbl[ eNof_DebugDipItem ] =
	{
		/**-------------------------------------------------------------------**/
		#define DEBUG_DIP_ITEM( _category, _name, _msg )	\
		\
		_T( _msg ),

		#include "core/debug/debug_dip/debug_dip_def.h"
		#undef DEBUG_DIP_ITEM
		/**-------------------------------------------------------------------**/
	};
}


/***************************************************************************
	debug_dip( namespace )
****************************************************************************/

const TCHAR*	debug_dip::GetDipCategoryName( eDebugDipItem in_eDip )
{
	ASSERT( in_eDip < ELEMENTSOF( s_szDebugDipCategoryTbl ) );

	return s_szDebugDipCategoryTbl[ in_eDip ];
}

const TCHAR*	debug_dip::GetDipItemName( eDebugDipItem in_eDip )
{
	ASSERT( in_eDip < ELEMENTSOF( s_szDebugDipItemTbl ) );

	return s_szDebugDipItemTbl[ in_eDip ];
}

b32		debug_dip::IsDip( eDebugDipItem e_debug_dip )
{
	return s_bDipOnOff_tbl[ e_debug_dip ];
}

void	debug_dip::SetDip( eDebugDipItem e_debug_dip, b32 b_set )
{
	s_bDipOnOff_tbl[ e_debug_dip ] = b_set;
}


void	debug_dip::InitDip()
{
	TCHAR sz_path[128] = {0};
	GetCurrentDirectory( 128, sz_path );
	wsprintf( sz_path, _T( "%s\\%s" ), sz_path, _T( "debug_dip.ini" ) );

	/**-------------------------------------------------------------------**/
	#define DEBUG_DIP_ITEM( _category, _name, _msg )						\
																			\
	{																		\
		cu32 ret =															\
			GetPrivateProfileInt( _T( #_category ), _T( #_name ), 0, sz_path );	\
																			\
		SetDip( eDebugDipItem_##_name##, ( ret != 0 ) );						\
	}

	#include "core/debug/debug_dip/debug_dip_def.h"
	#undef DEBUG_DIP_ITEM
	/**-------------------------------------------------------------------**/
};

void	debug_dip::FinDip()
{
	TCHAR sz_path[128] = {0};
	GetCurrentDirectory( 128, sz_path );
	wsprintf( sz_path, _T( "%s\\%s" ), sz_path, _T( "debug_dip.ini" ) );

	tstring	str_text[ eNof_DebugDipCategory ];
	/**-------------------------------------------------------------------**/
	#define DEBUG_DIP_ITEM( _category, _name, _msg )	\
														\
	{													\
		TCHAR sz_unit[256] = {0};						\
		cb32 b_on ( IsDip( eDebugDipItem_##_name## ) );	\
		wsprintf(										\
			sz_unit,									\
			_T( "%s=%d\r\n" ),							\
			_T( #_name ),								\
			static_cast<UINT>( b_on )					\
			);											\
														\
		str_text[ eDebugDipCategory_##_category ] += sz_unit;	\
														\
	}

	#include "core/debug/debug_dip/debug_dip_def.h"
	#undef DEBUG_DIP_ITEM
	/**-------------------------------------------------------------------**/

	for( u32 i=0; i<eNof_DebugDipCategory; ++i )
	{
		TCHAR sz_temp[256] = {0};
		wsprintf( sz_temp, _T( "%s\0\0" ), str_text[i].c_str() );
		sz_temp[ _tcscnlen( sz_temp, 256 ) - 1 ] = _T( '\0' );

		cb32 ret =
			WritePrivateProfileSection(
				s_szDebugDipCategoryTbl[i],
				sz_temp, sz_path
				);
	
		VERIFY( ret );
	}
};

