/***************************************************************************/
/** @file       window.cpp
    @brief      AvP[V(EBhE)̎
    @author     shom
    @internal
****************************************************************************/

#include "pch_core.h"

#include "window.h"

#include "window_def.h"

#include "core/app.h"


using namespace window_def;


namespace
{
	b32 s_bWindowClose = FALSE;

	b32 s_bWindowActive = TRUE;
	b32 s_bMessageBoxAppearing = FALSE;

	u32 s_uClientWidth  = sc_client_width_init;
	u32 s_uClientHeight = sc_client_height_init;
	u32 s_uWindowPosX   = sc_window_pos_x_init;
	u32 s_uWindowPosY   = sc_window_pos_y_init;
}


/***************************************************************************
	window( namespace )
****************************************************************************/

#ifdef DX

HWND	window::InitApp( HINSTANCE hinst, int nCmdShow )
{
	///EBhENX̓o^
	WNDCLASSEX	wc	=
	{
		sizeof( WNDCLASSEX ),			// ̍\̂̃TCY
		NULL,							// EChẼX^C(default)
		(WNDPROC)callback_msg_proc,		// bZ[W֐̓o^
		0, 0,							// ʏ͎gȂ̂ŏ0
		hinst,							// CX^Xւ̃nh
		NULL,							// ACR
		LoadCursor( NULL, IDC_ARROW ),	// J[\̌`
		WHITE_BRUSH, NULL,				// wiȂAj[
		sc_sz_wnd_class_name,			// NX̎w
		NULL							// ACR
	};

	if( RegisterClassEx( &wc ) == 0 )
	{
		DEBUG_BREAK();
		return NULL;
	}

	///CEEBhE̍쐬
	HWND h_wnd;
	{
		h_wnd = CreateWindow(
					sc_sz_wnd_class_name, sc_sz_wnd_name, 
					~(WS_MAXIMIZEBOX | WS_THICKFRAME) & WS_OVERLAPPEDWINDOW, 
					//ő剻{^ȂEEύX̂łȂ
					0, 0, s_uClientWidth, s_uClientHeight, 
					GetDesktopWindow(),
					NULL, hinst, NULL
					);
	}{ ASSERT( h_wnd ); }

	//EBhETCY̍Đݒ
	//--EBhETCYNCAg̈̑傫ƂĎw肵߁j
	RECT cRect, wRect;
	if( GetClientRect( h_wnd, &cRect ) == 0 )
	{
		DEBUG_BREAK();
		return NULL;
	}
	if( GetWindowRect( h_wnd, &wRect ) == 0 )
	{
		DEBUG_BREAK();
		return NULL;
	}
	int ww = s_uClientWidth +
			 ((wRect.right - wRect.left) - (cRect.right - cRect.left));
	int wh = s_uClientHeight +
			 ((wRect.bottom - wRect.top) - (cRect.bottom - cRect.top));

	if( SetWindowPos( h_wnd, HWND_TOP, s_uWindowPosX, s_uWindowPosY,
					  ww, wh, SWP_SHOWWINDOW ) == 0 )
	{
		DEBUG_BREAK();
		return NULL;
	}

	///EBhE̕\
	ShowWindow( h_wnd, nCmdShow );
	UpdateWindow( h_wnd );

	///WM_PAINT𗘗pȂ
	ValidateRect( h_wnd, 0 );

	return h_wnd;
}

int		window::FinApp( HWND h_wnd, HINSTANCE h_inst )
{
	if( !s_bWindowClose )
	{
		VERIFY( DestroyWindow( h_wnd ) != 0 );
	}

	///EBhENX̓o^
	if( UnregisterClass( sc_sz_wnd_class_name, h_inst ) == 0 )
	{
		DXTRACE_ERR( _T( "WinMain UnregisterClass" ), GetLastError() );
		return -1;
	}

	return 0;
}


/**
 * bZ[WpR[obN֐
 * 
 * @param h_wnd		EBhEnh
 * @param msg		bZ[W
 * @param w_param	bZ[W̍ŏ̃p[^
 * @param l_param	bZ[W2Ԗڂ̃p[^
 * 
 * @return : bZ[Wʂ0  s: -1
 */

// *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *
namespace
{
	b32		destroy_window( HWND h_wnd )
	{
		if( DestroyWindow( h_wnd ) == 0 )
		{
			DEBUG_BREAK();

			return FALSE;
		}
		else
		{
			s_bWindowClose = TRUE;

			return TRUE;
		}		
	}
}
// *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *

LRESULT CALLBACK	window::callback_msg_proc(
	HWND   h_wnd,
	UINT   msg,
	WPARAM w_param,
	LPARAM l_param
	)
{
	switch( msg )
	{
		case WM_DESTROY:  // - EBhEj -
			{
				///bZ[WI
				PostQuitMessage(0);	//WM_QUITM
	
				///Q[[vI
				app::StopAppLoop();
	
				return S_OK;
			}
			//break;

		case WM_CLOSE:	  // - ~ꂽ -
			{
				const b32 b_destory_window = destroy_window( h_wnd );

				// EBhEjAcase:WM_DESTROY֐ڂ
				return b_destory_window ? S_OK : E_FAIL;
			}
			//break;

		case WM_KEYDOWN:  // - L[ꂽ -
			{
				//ESCL[FAvP[VI
				if( (int)w_param == VK_ESCAPE )
				{
					//mF_CAOo
					s_bMessageBoxAppearing = TRUE;
					int	result	= MessageBoxEx(
							h_wnd, _T( "f܂H" ), sc_sz_wnd_name,
							MB_YESNO | MB_ICONQUESTION | MB_DEFBUTTON2,
							LANG_JAPANESE
							);
					s_bMessageBoxAppearing = FALSE;
	
					ASSERT( result != 0 );
					if( result != IDNO/*choise cancel*/ )
					{
						//EBhEjAcase:WM_DESTROY֐ڂ
						destroy_window( h_wnd );
					}
				}
	
				return 0;
			}
			//break;

		case WM_ACTIVATE:	//EBhẼANeBuEANeBu
			{
				if( w_param == WA_INACTIVE )
					//ANeBu
				{
					s_bWindowActive  = FALSE;
				}
				else
					//ANeBu
				{
					///Cvbg̕A
					//restart_device();

					s_bWindowActive  = TRUE;
				}
	
				return 0;
			}
			//break;

		default:	//ftHg̃bZ[W
			{
				return DefWindowProc( h_wnd, msg, w_param, l_param );
			}
			//break;
	}
}

#endif	//DX

b32		window::IsWindowActive()
{
	return s_bWindowActive;
}

b32		window::IsMessageBoxAppearing()
{
	return s_bMessageBoxAppearing;
}

u32		window::GetClientWidth()
{
	return s_uClientWidth;
}

u32		window::GetClientHeight()
{
	return s_uClientHeight;
}

void	window::SetClientWidth( u32 width )
{
	s_uClientWidth = width;
}

void	window::SetClientHeight( u32 height )
{
	s_uClientHeight = height;
}

u32		window::GetWindowPosX()
{
	return s_uWindowPosX;
}

u32		window::GetWindowPosY()
{
	return s_uWindowPosY;
}

void	window::SetWindowPosX( u32 x )
{
	s_uWindowPosX = x;
}

void	window::SetWindowPosY( u32 y )
{
	s_uWindowPosY = y;
}


