/***************************************************************************/
/** @file       mm_vector.h
    @brief      Zp֐
    @author     shom
****************************************************************************/

#pragma once


namespace mm
{
	///--	generation
	//--	constant value
	__declspec( dllexport )	void zero_v( vec2f& v );
	__declspec( dllexport )	void zero_v( vec3f& v );
	__declspec( dllexport )	void zero_v( vec4f& v );
	__declspec( dllexport )	vec2f zero_v2();
	__declspec( dllexport )	vec3f zero_v3();
	__declspec( dllexport )	vec4f zero_v4();

	__declspec( dllexport )	void half_v( vec2f& v );
	__declspec( dllexport )	void half_v( vec3f& v );
	__declspec( dllexport )	void half_v( vec4f& v );
	__declspec( dllexport )	vec2f half_v2();
	__declspec( dllexport )	vec3f half_v3();
	__declspec( dllexport )	vec4f half_v4();

	__declspec( dllexport )	void one_v( vec2f& v );
	__declspec( dllexport )	void one_v( vec3f& v );
	__declspec( dllexport )	void one_v( vec4f& v );
	__declspec( dllexport )	vec2f one_v2();
	__declspec( dllexport )	vec3f one_v3();
	__declspec( dllexport )	vec4f one_v4();

	__declspec( dllexport )	void neg_v( vec2f& v );
	__declspec( dllexport )	void neg_v( vec3f& v );
	__declspec( dllexport )	void neg_v( vec4f& v );
	__declspec( dllexport )	vec2f neg_v2();
	__declspec( dllexport )	vec3f neg_v3();
	__declspec( dllexport )	vec4f neg_v4();
	//--

	//--	specification value
	__declspec( dllexport )	vec2f get_v( f32 x, f32 y );
	__declspec( dllexport )	vec3f get_v( f32 x, f32 y, f32 z );
	__declspec( dllexport )	vec4f get_v( f32 x, f32 y, f32 z, f32 w );

	__declspec( dllexport )	vec2f get_v2_all( f32 in_val );
	__declspec( dllexport )	vec3f get_v3_all( f32 in_val );
	__declspec( dllexport )	vec4f get_v4_all( f32 in_val );
	//--
	///--

	///--	conversion	
	__declspec( dllexport )	vec3f v2_to_v3( const vec2f& in_v2, f32 in_z = 0.0f );
	__declspec( dllexport )	vec4f v3_to_v4( const vec3f& in_v3, f32 in_w = 0.0f );
	__declspec( dllexport )	vec2f v3_to_v2( const vec3f& in_v3 );
	__declspec( dllexport )	vec3f v4_to_v3( const vec4f& in_v4 );
	///--

	///--	basic arithmetic operation
	__declspec( dllexport )	vec2f add_v( const vec2f& in_v2_1, const vec2f& in_v2_2 );
	__declspec( dllexport )	vec3f add_v( const vec3f& in_v3_1, const vec3f& in_v3_2 );
	__declspec( dllexport )	vec4f add_v( const vec4f& in_v4_1, const vec4f& in_v4_2 );

	__declspec( dllexport )	vec2f add_x_v( const vec2f& in_v2_1, f32 in_x );
	__declspec( dllexport )	vec3f add_x_v( const vec3f& in_v3_1, f32 in_x );
	__declspec( dllexport )	vec4f add_x_v( const vec4f& in_v4_1, f32 in_x );

	__declspec( dllexport )	vec2f add_y_v( const vec2f& in_v2_1, f32 in_y );
	__declspec( dllexport )	vec3f add_y_v( const vec3f& in_v3_1, f32 in_y );
	__declspec( dllexport )	vec4f add_y_v( const vec4f& in_v4_1, f32 in_y );

	__declspec( dllexport )	vec3f add_z_v( const vec3f& in_v3_1, f32 in_z );
	__declspec( dllexport )	vec4f add_z_v( const vec4f& in_v4_1, f32 in_z );

	__declspec( dllexport )	vec4f add_w_v( const vec4f& in_v4_1, f32 in_w );

	__declspec( dllexport )	vec2f sub_v( const vec2f& in_v2_1, const vec2f& in_v2_2 );
	__declspec( dllexport )	vec3f sub_v( const vec3f& in_v3_1, const vec3f& in_v3_2 );
	__declspec( dllexport )	vec4f sub_v( const vec4f& in_v4_1, const vec4f& in_v4_2 );

	__declspec( dllexport )	vec2f sub_x_v( const vec2f& in_v2_1, f32 in_x );
	__declspec( dllexport )	vec3f sub_x_v( const vec3f& in_v3_1, f32 in_x );
	__declspec( dllexport )	vec4f sub_x_v( const vec4f& in_v4_1, f32 in_x );

	__declspec( dllexport )	vec2f sub_y_v( const vec2f& in_v2_1, f32 in_y );
	__declspec( dllexport )	vec3f sub_y_v( const vec3f& in_v3_1, f32 in_y );
	__declspec( dllexport )	vec4f sub_y_v( const vec4f& in_v4_1, f32 in_y );

	__declspec( dllexport )	vec3f sub_z_v( const vec3f& in_v3_1, f32 in_z );
	__declspec( dllexport )	vec4f sub_z_v( const vec4f& in_v4_1, f32 in_z );

	__declspec( dllexport )	vec4f sub_w_v( const vec4f& in_v4_1, f32 in_w );

	__declspec( dllexport )	vec2f mul_v( const vec2f& in_v2_1, const f32 in_val );
	__declspec( dllexport )	vec3f mul_v( const vec3f& in_v3_1, const f32 in_val );
	__declspec( dllexport )	vec4f mul_v( const vec4f& in_v4_1, const f32 in_val );

	__declspec( dllexport )	vec2f div_v( const vec2f& in_v2_1, const f32 in_val );
	__declspec( dllexport )	vec3f div_v( const vec3f& in_v3_1, const f32 in_val );
	__declspec( dllexport )	vec4f div_v( const vec4f& in_v4_1, const f32 in_val );
	///--

	///--	utility funcs
	__declspec( dllexport )	f32 length( const vec2f& v );
	__declspec( dllexport )	f32 length( const vec3f& v );
	__declspec( dllexport )	f32 length( const vec4f& v );

	__declspec( dllexport )	f32 length_sq( const vec2f& v );
	__declspec( dllexport )	f32 length_sq( const vec3f& v );
	__declspec( dllexport )	f32 length_sq( const vec4f& v );

	__declspec( dllexport )	f32 dot( const vec2f& v1, const vec2f& v2 );

	__declspec( dllexport )	vec2f normalize( const vec2f& v_in );

	__declspec( dllexport )	vec2f mid_point( const vec2f& v1, const vec2f& v2 );

	__declspec( dllexport )	vec2f translate( const vec2f& v, const vec2f& v_move );
	__declspec( dllexport )	vec2f rotate( const vec2f& v, f32 rad );
	__declspec( dllexport )	vec2f rotate_on_pivot( const vec2f& v, f32 rad, const vec2f& v_pos_pivot );

	__declspec( dllexport )	vec2f bezier(
		const vec2f& v1, const vec2f& v2, const vec2f& v3, const vec2f& v4,
		f32 t
		);

	__declspec( dllexport )	f32 distance( const vec2f& v_pos_1, const vec2f& v_pos_2 );
	__declspec( dllexport )	f32 dist( const vec2f& v_pos_1, const vec2f& v_pos_2 );	//abbr.
	__declspec( dllexport )	vec2f direction( const vec2f& v_pos_src, const vec2f& v_pos_dest );
	__declspec( dllexport )	vec2f dir( const vec2f& v_pos_src, const vec2f& v_pos_dest );	//abbr.
	///--
}


#define VEC3_ARGS( _in_v3 )	_in_v3.x, _in_v3.y, _in_v3.z
