/***************************************************************************/
/** @file       Font_Gdi.inl
    @brief      font rendering by gdi
    @author     shom
****************************************************************************/

#include "Font_Gdi.h"

#include "Font_Gdi_Raw.h"


/***************************************************************************
	CFont_Gdi
****************************************************************************/

CFont_Gdi::CFont_Gdi()
:
	m_pRaw( new CFont_Gdi_Raw() )
,	m_pD3dxFont( NULL )
,	m_pD3xdSprite( NULL )
{
	m_pRaw->Create( &m_pD3dxFont );
}

void	CFont_Gdi::Draw(
	const TCHAR* in_szText, const font_def::FontContext_t& in_Context
	)
{
	m_pRaw->SetPos( SCAST<u32>( in_Context.uPosX ), SCAST<u32>( in_Context.uPosY ) );
	m_pRaw->SetSize( SCAST<u32>( in_Context.v2Size.y ), SCAST<u32>( in_Context.v2Size.x ) );
	m_pRaw->SetStyle( in_Context.bItalic, in_Context.bWeight, in_Context.bUseAnci );

	m_pRaw->Draw(
		m_pD3dxFont, in_szText,
		in_Context.uColor, in_Context.bShadow, m_pD3xdSprite
		);
}

		