/***************************************************************************/
/** @file       Font_Gdi_Raw.inl
    @brief      font rendering by gdi
    @author     shom
    @internal
****************************************************************************/

#include "font_gdi.h"

#include "core/graphic/render_dx.h"


/***************************************************************************
	CFont_Gdi_Raw
****************************************************************************/

CFont_Gdi_Raw::CFont_Gdi_Raw()
:
m_uPosX( 0 ),
m_uPosY( 0 ),
m_font_desc()//,
{
	SetDefault();
}

void	CFont_Gdi_Raw::SetDefault()
{
	m_uPosX = 0;
	m_uPosY = 0;
	m_font_desc.Height	= 24;
	m_font_desc.Width	= 0;
	m_font_desc.Italic	= false;
	m_font_desc.CharSet	= SHIFTJIS_CHARSET;	//{gp
#if !1
	strncpy_s(
			 m_font_desc.FaceName,
			 _T( "lr " ),
			 sizeof( m_font_desc.FaceName ) * sizeof( char )
			 );
#endif	
}

void	CFont_Gdi_Raw::SetPos( u32 in_uPosX, u32 in_uPosY )
{
	m_uPosX = in_uPosX;
	m_uPosY = in_uPosY;
}

void	CFont_Gdi_Raw::SetSize( u32 height, u32 width )
{
	m_font_desc.Height	= height;
	m_font_desc.Width	= width;
}

void	CFont_Gdi_Raw::SetStyle( b32 b_italic, b32 b_weight, b32 b_use_anci )
{
	m_font_desc.Italic	= b_italic;
	m_font_desc.Weight	= ( b_weight ) ? 1000 : 500;
	m_font_desc.CharSet	= ( b_use_anci ) ? ANSI_CHARSET : SHIFTJIS_CHARSET;
}

void	CFont_Gdi_Raw::Create( LPD3DXFONT* out_ppD3dxFont )
{
	///_tHg̍쐬
	const HRESULT hr =
		D3DXCreateFontIndirect( g_p_render->GetDevice(), &m_font_desc, out_ppD3dxFont );
	DBREAK_IF_FAILED( hr );
}

void	CFont_Gdi_Raw::Draw(
	const	LPD3DXFONT		p_d3dx_font,
	const	LPCWSTR			sz_msg,
			u32				color,
			b32				b_shadow,
	const	LPD3DXSPRITE	p_sprite
	)
{
	if( p_sprite )
	{
		p_sprite->Begin( D3DXSPRITE_ALPHABLEND | D3DXSPRITE_SORT_TEXTURE );	
	}

	const u32 uWidth ( ( m_font_desc.Width == 0 ) ? m_font_desc.Height : m_font_desc.Width );
	RECT rect =
		{ m_uPosX, m_uPosY, m_uPosX + uWidth, m_uPosY + m_font_desc.Height };

	if( b_shadow )
	{
		RECT rect_shadow = {0};	
		rect_shadow.left = rect.left + 2;
		rect_shadow.top  = rect.top  + 2;

		const HRESULT hr_shadow =
			p_d3dx_font->DrawText(
						p_sprite,
						sz_msg,
						-1,				//B-1ŎvZB
						&rect_shadow,	//`͈
						DT_NOCLIP,		//tH[}bg
						COLOR_BLACK
						);
		DBREAK_IF_FAILED( hr_shadow );
	}
	
	const HRESULT hr =
		p_d3dx_font->DrawText(
					p_sprite,
					sz_msg,
					-1,			//B-1ŎvZB
					&rect,		//`͈
					DT_NOCLIP,	//tH[}bg
					color
					);
	DBREAK_IF_FAILED( hr );

	if( p_sprite )
	{
		p_sprite->End();
	}
}
