/***************************************************************************/
/** @file       input_base.cpp
    @brief      
    @author     shom
    @internal
----------------------------------------------------------------------------
    $id
****************************************************************************/

#include "pch_core.h"

#include "input_base.h"

#include "raw/input_raw_base.h"


/***************************************************************************
	cinput_base
****************************************************************************/

cinput_base::cinput_base()
:
m_p_input_raw( NULL )//,
{
}

cinput_base::~cinput_base()
{
	my_safe_del( m_p_input_raw );
}

b32		cinput_base::Initialize(
#ifdef DX
	HWND h_wnd
#endif
	)
{
	ASSERT( m_p_input_raw );

	return (
		m_p_input_raw &&
#ifdef DX
		m_p_input_raw->Initialize( h_wnd )
#else //elif GL
		m_p_input_raw->Initialize()
#endif
		);
}

void	cinput_base::Finalize()
{
}

void	cinput_base::Update()
{
}

void	cinput_base::RestartDevice()
{
	if( m_p_input_raw )
	{	
		m_p_input_raw->RestartDevice();
	}
}
