/***************************************************************************/
/** @file       CWaveFile.cpp
	@brief      
	@author     shom
	@internal
----------------------------------------------------------------------------
	$id
****************************************************************************/

#include "pch_core.h"
#pragma warning( disable : 4819 )  // WarninghUnicode`ł̕ۑh𖳌
#include "WaveFile.h"
#pragma warning( default : 4819 )

#pragma comment( lib, "winmm.lib" )


/***************************************************************************
	CWaveFile
****************************************************************************/

CWaveFile::CWaveFile()
{
}

CWaveFile::~CWaveFile()
{
}

//-------------------------------------------------------------------
// Wavet@CJ
//-------------------------------------------------------------------
HRESULT	CWaveFile::Open(
	LPWSTR		WvName,
	theWaveData	*pWvData
	)
{
	///Wavet@CJ
	pWvData->Hmmio = mmioOpen( WvName,
							   // ǉ̃p[^
							   NULL,		  // Ȃ
							   // tO
							   MMIO_ALLOCBUF  // obt@Oꂽo͗pɊJ
							   | MMIO_READ	  // ǂݎpƂĊJ
							 );
	if( pWvData->Hmmio == NULL )
	{
		DXTRACE_ERR( _T("FAIL:mmioOpen"), E_FAIL );
	}


	///RIFF`NāAq`Nɍ~ARIFF`N̏擾
	pWvData->RiffInfo.fccType	= mmioFOURCC( 'W', 'A', 'V', 'E' );
	if( mmioDescend( pWvData->Hmmio,
					 // `N̊i[
					 &(pWvData->RiffInfo),
					 // e`Ñ`N̊i[
					 NULL,					 // [g𒲂ׂ
					 // tO
					 MMIO_FINDRIFF			 // ʎqhRiFFhŁAw肳ꂽtH[^Cṽ`N
				    ) != MMSYSERR_NOERROR )
	{
		if( FAILED( Close( pWvData ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:Close"), E_FAIL );
		}

		return DXTRACE_ERR( _T("FAIL:mmioDescend <RIFF>"), E_FAIL );
	}

	//Lȃt@CmF
	if( ( pWvData->RiffInfo.ckid != FOURCC_RIFF )
		|| ( pWvData->RiffInfo.fccType != mmioFOURCC( 'W', 'A', 'V', 'E' ) ) )
	{
		if( FAILED( this->Close( pWvData ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:Close"), E_FAIL );
		}

		return DXTRACE_ERR( _T("FAIL:mmioFOURCC WAVE"), E_FAIL );
	}


	///tH[}bg`Ň
	MMCKINFO CkInfo;
	CkInfo.ckid = mmioFOURCC( 'f', 'm', 't', ' ' );	 // hfmt hʎqi[
	if( mmioDescend( pWvData->Hmmio, &CkInfo, &(pWvData->RiffInfo),
					 MMIO_FINDCHUNK ) // w肳ꂽʎq̃`N
		!= MMSYSERR_NOERROR )
	{
		if( FAILED( this->Close( pWvData ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:Close"), E_FAIL );
		}

		return DXTRACE_ERR( _T("FAIL:mmioDescend <fmt >"), E_FAIL );
	}


	// === tH[}bg`Ñ`N̊l ===
	// - tH[}bg`Nʂȃp[^ꍇAłȂ -
	if( CkInfo.cksize < (LONG)sizeof(PCMWAVEFORMAT) )
	{
		if( FAILED( Close( pWvData ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:Close"), E_FAIL );
		}

		return DXTRACE_ERR( _T( "FAIL:sizeof(PCMWAVEFORMAT)" ), E_FAIL );
	}

	// - tH[}bg`Ñ`N擾 -
	WAVEFORMATEX pcmwf;
	if( mmioRead( pWvData->Hmmio, (HPSTR)&pcmwf, sizeof(pcmwf) ) != sizeof(pcmwf) )
	{
		if( FAILED( Close( pWvData ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:Close"), E_FAIL );
		}

		return DXTRACE_ERR( _T("FAIL:mmioRead"), E_FAIL );
	}

	// - PCMtH[}bgłȂꍇAłȂ -
	if( pcmwf.wFormatTag != WAVE_FORMAT_PCM )
	{
		if( FAILED( Close( pWvData ) ) )
		{
			return DXTRACE_ERR( _T( "FAIL:Close" ), E_FAIL );
		}

		return DXTRACE_ERR( _T( "FAIL:WAVE_FORMAT_PCM" ), E_FAIL );
	}

	// - 擾`Ni[ -
	memcpy( &pWvData->WvFormatEx, &pcmwf, sizeof(pcmwf) );
	pWvData->WvFormatEx.cbSize = 0;	 // ǉtH[}bgłȂ


	// === tH[}bg`N甲āARIFF`Nɖ߂ ===
	if( mmioAscend( pWvData->Hmmio, &CkInfo, 0 ) != MMSYSERR_NOERROR )
	{
		if( FAILED( Close( pWvData ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:Close"), E_FAIL );
		}

		return DXTRACE_ERR( _T("FAIL:mmioAscend"), E_FAIL );
	}


	// === ǂݏoʒu𓪂ɖ߂ === 
	if( FAILED( Rewind( pWvData )) )
	{
		if( FAILED( Close( pWvData ) ) )
		{
			return DXTRACE_ERR( _T("FAIL:Close"), E_FAIL );
		}

		return DXTRACE_ERR( _T("FAIL:Rewind"), E_FAIL );
	}

	return S_OK;
}


/**
 * Wavet@C
 * 
 * @param pWvData
 * 
 * @return 
 */
HRESULT	CWaveFile::Close(
	theWaveData* pWvData
	)
{
	if( !pWvData->Hmmio )
	{
		return S_FALSE;
	}

	///t@C
	if( FAILED( mmioClose( pWvData->Hmmio, 0 ) ) )
	{
		return DXTRACE_ERR( _T("FAIL:mmioClose"), GetLastError() );
	}

	return S_OK;
}


/**
 * JWavet@Cf[^ǂݏo
 * 
 * @param pWvData
 * @param ToReadSz
 * @param pBuf
 * @param pReadedSz
 * 
 * @return 
 */
HRESULT CWaveFile::Read(
					   theWaveData* pWvData,
					   u32        ToReadSz,
					   BYTE*        pBuf,
					   u32*       pReadedSz
					   )
{
	///
	//G[`FbN
	if( pWvData->Hmmio == NULL || pBuf == NULL || pReadedSz == NULL )
	{
		DXTRACE_ERR( _T(""), E_FAIL );
	}

	// - ToReadSz0ł΁As͂Ȃ -
	if( ToReadSz == 0 )
	{
		*pReadedSz	= 0;
		DXTRACE_ERR( _T(""), S_OK );
	}

	// - pReadedSz[Zbg -
	*pReadedSz	= 0;


	// === t@CɊւ擾At@Co̓obt@ւ̒ڃANZXJn ===
	MMIOINFO	Ioinfo;
	if( mmioGetInfo( pWvData->Hmmio, &Ioinfo, 0 ) != 0 )
	{
		DXTRACE_ERR( _T("FAIL:mmioGetInfo"), E_FAIL );
	}


	// === ǂݍރTCYAg`f[^ɍ킹 ===
	UINT	ReadBytes	= ToReadSz;
	if( ReadBytes > pWvData->DataInfo.cksize )
	{
		ReadBytes   = pWvData->DataInfo.cksize;
	}


	///f[^̓ǂݏo
	for( u32 iReadByte=0; iReadByte<ReadBytes; iReadByte++ )
	{
		// - t@CI[ł邩 -
		if( Ioinfo.pchNext == Ioinfo.pchEndRead )
		{
			// pchNextpchEndRead̒lXV
			if( mmioAdvance( pWvData->Hmmio, &Ioinfo, MMIO_READ ) != 0 )
			{
				DXTRACE_ERR( _T("FAIL:mmioAdvance"), E_FAIL );
			}

			// XVɂւ炸At@CI[Ă
			if( Ioinfo.pchNext == Ioinfo.pchEndRead )
			{
				DXTRACE_ERR( _T("FAIL:Ioinfo.pchNext"), E_FAIL );
			}
		}

		// - Rs[ -
		*((BYTE*)pBuf + iReadByte) = *((BYTE*)Ioinfo.pchNext);

		// - ǂݐi߂ -
		Ioinfo.pchNext++;
	}


	// === 擾XVAt@Co̓obt@ւ̒ڃANZXI ===
	if( mmioSetInfo( pWvData->Hmmio, &Ioinfo, 0 ) != 0 )
	{
		DXTRACE_ERR( _T("FAIL:mmioSetInfo"), E_FAIL );
	}


	// === ۂɓǂݍ܂ꂽf[^TCYReadedSzɊi[ ===
	*pReadedSz = ReadBytes;


	return S_OK;
}


/**
 * Wavet@C̓ǂݏoʒuAf[^`Nɓo
 * 
 * @param pWvData
 * 
 * @return 
 */
HRESULT CWaveFile::Rewind(
	theWaveData* pWvData
	)
{
	if( pWvData->Hmmio == NULL )
	{
		return DXTRACE_ERR( _T("pWvData->Hmmio is null pointer"), E_FAIL );
	}


	///Wavet@C̊߂
	//t@CʒuRIFF`N̓ɕύX
	if( mmioSeek( pWvData->Hmmio,
				  // ItZbg
				  pWvData->RiffInfo.dwDataOffset + sizeof(FOURCC),	// RIFF`N̓
				  // ItZbg̉ߕ@tO
				  SEEK_SET )  // t@C̐擪ItZbgoCg̈ʒuT
		== -1 )
	{
		return DXTRACE_ERR( _T("FAIL:mmioSeek"), E_FAIL );
	}


	// === f[^`NTāȀpWvData.DataInfoɊi[ ===
	pWvData->DataInfo.ckid = mmioFOURCC( 'd', 'a', 't', 'a' );
	if( mmioDescend( pWvData->Hmmio, &(pWvData->DataInfo),
					 &(pWvData->RiffInfo), MMIO_FINDCHUNK )
		!= MMSYSERR_NOERROR )
	{
		return DXTRACE_ERR( _T("FAIL:mmioDescend"), E_FAIL );
	}

	return S_OK;
}

