/***************************************************************************/
/** @file       mm_float.cpp
    @brief      Zp֐
    @author     shom
****************************************************************************/

#include "pch_util.h"

#include "mm.h"


/***************************************************************************
	mm( namespace )
****************************************************************************/

f32		mm::abs( f32 in_fVal )
{
	return fabs( in_fVal );
}

b32		mm::is_equal_f( f32 num_1, f32 num_2 )
{
    return ( abs( num_1 - num_2 ) < FLT_EPSILON );
}

b32 	mm::is_equal_zero_f( f32 in_num )
{
	return ( is_equal_f( in_num, 0.0f ) );
}

f32 	mm::square( f32 val )
{
	return ( val * val );
}

f32 	mm::sq( f32 val )
{
	return square( val );
}

f32		mm::pow( f32 val, f32 num )
{
	f32 ret = 1.0f;
	
	for( int i=0; i<num; ++i )
	{
		ret *= val;
	}

	return ret;
}

f32		mm::sqrt( f32 val )
{
	if( val == 0 ) { return 0; }

	///--
	const f32 x_init = val;

	f32 x = val, x_prev;

	do
	{
		x_prev = x;

		x = ( x_prev + x_init / x_prev ) / 2;
	}
	while( x < x_prev );
	///--

	return x_prev;
}

f32		mm::lerp( f32 in_fMin, f32 in_fMax, f32 in_fRatio )
{
	return ( in_fMax - in_fMin ) * in_fRatio + in_fMin;
}

f32 	mm::ratio( f32 in_fVal, f32 in_fMin, f32 in_fMax )
{
	cf32 fBottom = ( in_fMin < in_fMax ) ? in_fMin : in_fMax;
	cf32 fTop = ( in_fMin < in_fMax ) ? in_fMax : in_fMin;

	return ( in_fVal - fBottom ) / ( fTop / fBottom );
}

f32		mm::half( f32 in_val )
{
	return ( in_val / 2.0f );
}

f32		mm::quarter( f32 in_val )
{
	return ( in_val / 4.0f );
}

f32		mm::minus( f32 in_val )
{
	return ( in_val * -1.0f );
}

f32		mm::pythagorean( f32 length_a, f32 length_b )
{
	return ( mm::sqrt( mm::square( length_a ) + mm::square( length_b ) ) );
}

f32		mm::pythagorean_inv( f32 length_sloping, f32 length_a )
{
	return (
		mm::sqrt( mm::square( length_sloping ) - mm::square( length_a ) )
		);
}

u32		mm::mul_as_float( u32 in_uVal, f32 in_fVal )
{
	return SCAST<u32>( SCAST<f32>( in_uVal ) * in_fVal );
}

