#include "my_funcs.h"
#include <stdio.h>

int main(int argc, const char* argv[])
{
  // 画像データをファイルから読み込む
  cv::Mat src = cv::imread("img/lena.jpg", cv::IMREAD_COLOR);
//  cv::Mat src = cv::imread("img/lena.jpg", cv::IMREAD_GRAYSCALE);

  // 画像の読み込みに失敗したらエラー終了する
  if(src.empty())
  {
    std::cerr << "Failed to open image file." << std::endl;
    return -1; 
  }

  cv::Mat dst = my_canny(src);

  cv::namedWindow("image", cv::WINDOW_AUTOSIZE);
  cv::imshow("image", src);
  cv::waitKey(0);
  cv::imshow("image", dst);
  cv::waitKey(0);
  cv::destroyAllWindows();

  return 0;
}

