package framework;

import framework.util.Debug;
import framework.Application;

/**
 * FPSを表示するクラス
 * @author syun
 */
class FpsView extends IToken
{
    private var m_tPrev:Float = 0; // １フレーム前のタイマ
    private var m_tNow:Float = 0; // 現在のタイマ
    private var m_tPast:Float = 0; // 経過時間
    private var m_nFrame:Int = 0; // フレーム数
    private var m_Fps:Float = 0; // 実際のFPS
    public static inline var FPS:Float = 60; // 指定のFPS

    public function new() {
        super();
    }

    public override function update():Void {

        /*
        // フレームレート固定化処理
        while (true)
        {
            var date:Date = new Date();
            m_tNow = date.getTime();
            var d:Float = (m_tNow - m_tPast);
            if (d > 1000/FPS)
            {
                m_tPast += d;
                trace("exe!" + d);
                break;
            }
            trace(d);
            return;
        }
        */

        m_tNow = flash.Lib.getTimer();
        m_tPast += m_tNow - m_tPrev;
        m_nFrame++;
        if (m_nFrame % FPS == 0)
        {
            m_Fps = 1000.0 / (m_tPast / FPS);
            m_nFrame = 0;
            m_tPast = 0;
        }
        m_tPrev = m_tNow;
    }
    public override function draw():Void {
        if(Debug.isDrawFps) {
            // FPS描画
            IToken.s_f.drawAscii(0, Application.Height()-FontManager.HEIGHT, "FPS:" + Math.floor(m_Fps));
        }
    }

}

