package framework;

/**
 * キーボードの入力管理
 * @author syun
 */
class Keyboard {
    /**
     * ボタンの状態
     */
    private var m_Button:Array<Bool>;
    /**
     * ボタンの状態（１フレーム前）
     */
    private var m_ButtonPrev:Array<Bool>;
    /**
     * 方向キーの状態
     */
    private var m_Arrow:Array<Bool>;
    /**
     * 方向キーの状態（１フレーム前）
     */
    private var m_ArrowPrev:Array<Bool>;

    private var m_AssignButton:Array<Int>;
    private var m_AssignArrow:Array<Int>;

    private var m_OnKeys:Map<Int, Bool>;
    private var m_OnKeysPrev:Map<Int, Bool>;

    /**
     * 方向キー（左）
     */
    public static inline var ARROW_LEFT:Int = 0;
    /**
     * 方向キー（上）
     */
    public static inline var ARROW_UP:Int = 1;
    /**
     * 方向キー（右）
     */
    public static inline var ARROW_RIGHT:Int = 2;
    /**
     * 方向キー（下）
     */
    public static inline var ARROW_DOWN:Int = 3;


    public static inline var MAX_BUTTON:Int = 6;

    public static inline var K_BEGIN:Int = 48;
    public static inline var K_END:Int  = 90;

    /**
     * コンストラクタ
     * @param	nPlayer プレイヤー数
     */
    public function new() {
        m_Button = new Array<Bool>();
        m_ButtonPrev = new Array<Bool>();
        m_Arrow = new Array<Bool>();
        m_ArrowPrev = new Array<Bool>();

        for(i in 0...MAX_BUTTON)
        {
            m_Button.push(false);
            m_ButtonPrev.push(false);
            m_Arrow.push(false);
            m_ArrowPrev.push(false);
        }

        m_AssignButton = new Array<Int>();
        m_AssignButton.push(InputManager.KEYCODE_Z); // 0
        m_AssignButton.push(InputManager.KEYCODE_X); // 1
        m_AssignButton.push(InputManager.KEYCODE_C); // 2

        m_AssignArrow = new Array<Int>();
        m_AssignArrow.push(InputManager.KEYCODE_LEFTARROW);
        m_AssignArrow.push(InputManager.KEYCODE_UPARROW);
        m_AssignArrow.push(InputManager.KEYCODE_RIGHTARROW);
        m_AssignArrow.push(InputManager.KEYCODE_DOWNARROW);

        m_OnKeys = new Map<Int, Bool>();
        m_OnKeysPrev = new Map<Int, Bool>();

        for(i in K_BEGIN...K_END) {
            m_OnKeys.set(i, false);
            m_OnKeysPrev.set(i, false);
        }

    }

    public function endFrame():Void
    {
        for (i in 0...MAX_BUTTON) {
            m_ButtonPrev[i] = m_Button[i];
        }
        for (i in 0...MAX_BUTTON) {
            m_ArrowPrev[i] = m_Arrow[i];
        }
        for(i in K_BEGIN...K_END) {
            m_OnKeysPrev.set(i, m_OnKeys.get(i));
        }
    }

    public function onKeyDown(keyCode:Int):Void {
        if(m_AssignButton != null) {
            for(i in 0...m_AssignButton.length) {
                if (keyCode == m_AssignButton[i]) {
                    m_Button[i] = true;
                }
            }
        }
        if (m_AssignArrow != null) {
            for(i in 0...m_AssignArrow.length) {
                if (keyCode == m_AssignArrow[i]) {
                    m_Arrow[i] = true;
                }
            }
        }

        // 押したキーマップに登録
        m_OnKeys.set(keyCode, true);
    }

    public function onKeyUp(keyCode:Int):Void {
        if(m_AssignButton != null) {
            for(i in 0...m_AssignButton.length) {
                if(keyCode == m_AssignButton[i]) {
                    m_Button[i] = false;
                }
            }
        }

        if (m_AssignArrow != null) {
            for (i in 0...m_AssignArrow.length) {
                if (keyCode == m_AssignArrow[i]) { m_Arrow[i] = false; }
            }
        }

        // 離したキーマップに登録
        m_OnKeys.set(keyCode, false);
    }

    public function isOn(index:Int):Bool {
        return m_Button[index];
    }

    public function isPress(index:Int):Bool {
        if(m_Button[index] == true && m_ButtonPrev[index] == false) {
            return true;
        }
        return false;
    }

    public function isOnArrow(index:Int):Bool {
        return m_Arrow[index];
    }

    public function isPressArrow(index:Int):Bool {
        if(m_Arrow[index] == true && m_ArrowPrev[index] == false) {
            return true;
        }
        return false;
    }

    public function isOnKey(key:String) {
        var code = key.charCodeAt(0);
        return m_OnKeys.get(code);
    }
    public function isPressKey(key:String) {
        var code = key.charCodeAt(0);
        if(m_OnKeys.get(code) && m_OnKeysPrev.get(code) == false) {
            return true;
        }
        return false;
    }

    /**
     * カーソルキーの入力を取得する（X方向)
     * @return 左の場合「-1」　右の場合「1」
     */
    public function getX():Int {
        return (m_Arrow[ARROW_LEFT] ? -1 : 0) + (m_Arrow[ARROW_RIGHT] ? 1 : 0);
    }

    /**
     * カーソルキーの入力を取得する(Y方向)
     * @return 上の場合「-1」　下の場合「1」
     */
    public function getY():Int {
        return (m_Arrow[ARROW_UP] ? -1 : 0) + (m_Arrow[ARROW_DOWN] ? 1 : 0);
    }
}
