package framework;

import flash.events.MouseEvent;
/**
 * マウスの入力管理
 * @author syun
 */
class Mouse
{
    private var m_bDown:Bool;
    private var m_bUp:Bool;
    private var m_On:Bool;
    private var m_OnPrev:Bool;
    private var m_Press:Bool;
    private var m_X:Int;
    private var m_Y:Int;
    public function new() {
        m_bDown = false;
        m_bUp = false;
        m_On = false;
        m_OnPrev = false;
        m_Press = false;
        m_X = cast(Main.WIDTH/2, Int);
        m_Y = cast(Main.HEIGHT/2, Int);
    }
    public function endFrame():Void {
        // 押し続けているかどうか判定
        if (m_bDown && m_bUp == false) {
            m_On = true;
        }
        else if (m_bDown && m_bUp) {
            if (m_On == false) {
                m_On = true;
            }
            else {
                m_On = false;
            }
            m_bDown = false;
            m_bUp = false;
        }

        // そのフレームに押したかどうか判定
        if (m_On && m_OnPrev == false) {
            m_Press = true;
        }
        else {
            m_Press = false;
        }
        m_OnPrev = m_On;
    }

    public function isOn():Bool {
        return m_On;
    }
    public function isPress():Bool {
        return m_Press;
    }

    public function x():Int {
        return m_X;
    }
    public function y():Int {
        return m_Y;
    }

    public function onMove(e:MouseEvent):Void {
        m_X = Std.int(e.stageX);
        m_Y = Std.int(e.stageY);
    }
    public function onClick(e:MouseEvent):Void {
        //m_PushPrev = true;
    }
    public function onDown(e:MouseEvent):Void {
        m_bDown = true;
    }
    public function onUp(e:MouseEvent):Void {
        m_bUp = true;
    }
}
