package framework.util;

/**
 * ...
 * @author syun
 */
class Maths {
    public static function randInt(a:Int, b:Int):Int {
        var tmp:Int = cast(Math.random() * 1000, Int);
        return cast((b - a + 1) * tmp / 1000 + a, Int);
    }
    public static function randNum(a:Float, b:Float):Float {
        return (b - a) * Math.random() + a;
    }
    public static function sinEx(deg:Float):Float {
        return Math.sin(deg2rad(deg));
    }
    public static function cosEx(deg:Float):Float {
        return Math.cos(deg2rad(deg));
    }
    public static function atan2Ex(x:Float, y:Float):Float {
        return rad2deg(Math.atan2(-y, x));
    }
    public static function sqrt(a:Float):Float {
        return Math.sqrt(a);
    }
    public static function distance(dx:Float, dy:Float):Float {
        return Math.sqrt(dx * dx + dy * dy);
    }
    /**
     * ラジアンを度に変換
     * @param	rad
     * @return 度
     */
    public static function rad2deg(rad:Float):Float {
        return rad * 180 / Math.PI;
    }
    /**
     * 度をラジアンに変換
     * @param	deg
     * @return ラジアン
     */
    public static function deg2rad(deg:Float):Float {
        return deg * Math.PI / 180;
    }
}
