#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pygame
from pygame.locals import *
import sys
import pygame.gfxdraw

from rpgraphics import *
from rpfont import *
from rpinput import *
from rpmusic import *

# アプリケーション管理
class Rp(object):
	def __init__(self, title, width, height):
		# 画面サイズ設定
		self.width, self.height = (width, height)

		# Pygame初期化
		pygame.init()

		# キャプションの設定
		self.setCaption(title)

		# アイコンの設定
		icon = pygame.image.load("resources/system/icon.png")
		icon.set_colorkey((0, 255, 0), RLEACCEL)
		pygame.display.set_icon(icon)

		# 画面生成
		self.screen = pygame.display.set_mode((self.width, self.height))

		# デバイス関連
		self.graphics = RpGraphics(self.screen)
		self.font     = RpFont(self.graphics)
		self.input    = RpInput()
		self.music    = RpMusic(self.graphics, self.font)

		# FPS関連
		self.fps          = 60
		self.fps_cnt      = 0
		self.fps_view     = 0
		self.fps_lastTick = 0
		self.prvTick      = self.getTicks()

	def setCaption(self, msg): pygame.display.set_caption(msg)
	def getCaption(self): return pygame.display.get_caption()

	def setFps(self, fps): self.fps = fps
	def getFps(self): return self.fps
	def getTicks(self): return pygame.time.get_ticks()

	def wait(self, msec): pygame.time.wait(msec)
	def delay(self, msec): pygame.time.delay(mesc)

	def update(self, tWait = -1):

		if(tWait == -1): tWait = 1000.0 / self.fps
		# ウェイト時間の計算
		nowTick  = 0
		leftTick = 0
		while True:
			nowTick = self.getTicks()
			leftTick = self.prvTick + tWait - nowTick
			if(leftTick < 1 or leftTick > 9999): break
			self.wait(1)
		# 保存
		self.prvTick = nowTick
		# FPS計測
		self.fps_cnt += 1
		if(int(self.fps_lastTick / 1000) != int(nowTick / 1000)):
			self.fps_view = self.fps_cnt
			self.fps_cnt = 0
			self.fps_lastTick = nowTick

		# 画面を初期化
		self.graphics.update()

		# イベント処理
		for event in pygame.event.get():
			if event.type == QUIT: sys.exit() # 終了イベント
			if event.type == KEYDOWN:
				# キーを押した
				if event.key == K_ESCAPE: sys.exit() # ESCキーは終了

		# キー入力更新
		self.input.updateNormal()

	def updateAfter(self):
		# 後処理
		self.graphics.flip()

	def quit(self):
		pygame.quit()

	def drawFps(self, x=-1, y=-1):
		if(x == -1): x = 0
		if(y == -1): y = self.height - self.font.getSizeAscii()
		s = "FPS:" + str(self.fps_view)
		self.font.drawAscii(s, x, y)

