﻿using UnityEngine;
using System.Collections;

public class Shot : MonoBehaviour {

	/// <summary>
	/// Animation timer.
	/// </summary>
	private int _tAnime = 0;

	public static Shot Add(Vector3 position, float direction, float speed) {
		GameObject prefab = (GameObject)Resources.Load ("Prefabs/Shot");
		GameObject shot = Instantiate (prefab, position, Quaternion.identity) as GameObject;
		Shot s = shot.GetComponent<Shot>();
		s.Create(direction, speed);

		return s;
	}

	public void Create(float direction, float speed) {
		// Setting velocity.
		Vector2 v;
		v.x = Mathf.Cos (Mathf.Deg2Rad * direction) * speed;
		v.y = Mathf.Sin (Mathf.Deg2Rad * direction) * speed;
		rigidbody2D.velocity = v;
	}

	void Start () {
		_tAnime = 0;
	}

	// Update is called once per frame
	void Update () {
	
		Vector2 pos = transform.position;
		bool bOut = Util.IsOut(pos, 0.5f);
		if(bOut) {
			// Out of Screen.
			Destroy(gameObject);
		}

		_tAnime++;
		Vector2 scale = transform.localScale;
		if(_tAnime%16 < 8) {
			scale.x = 0.25f;
			scale.y = 0.25f;
		}
		else {
			scale.x = 0.3f;
			scale.y = 0.3f;
		}
		transform.localScale = scale;
	}
}
