﻿using UnityEngine;
using System.Collections;

public class SpriteFont : MonoBehaviour {

	private static string _decode = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz.()[]#$%&'" + '"' + "!?^+-*/=;:_<>|@`";
	const float FONT_SIZE = 0.08f;

	// Use this for initialization
	void Start () {
		SetText ("0123456789");
	}

	public void SetText(string text) {
		int i = 0;

		foreach(char c in text) {
			int idx = _decode.IndexOf(c);
			GameObject obj = null;
			if(i < transform.childCount) {
				obj = transform.GetChild(i).gameObject;
			}
			else {
				GameObject prefab = Resources.Load ("Prefabs/SpriteChar") as GameObject;
				Vector3 pos = new Vector3(i * transform.localScale.x * FONT_SIZE, 0, 0);
				obj = Instantiate(prefab) as GameObject;
				obj.transform.parent = transform;
				obj.transform.localPosition = pos;
				obj.transform.localScale = new Vector3(1, 1, 1);
			}
			SpriteChar sc = obj.GetComponent<SpriteChar>();
			sc.SetChar(idx);
			i++;
		}
	}
	
	// Update is called once per frame
	void Update () {
	
	}
}
