﻿using UnityEngine;
using System.Collections;

public class Util : MonoBehaviour {

	private const float MARGIN = 0.5f;
	public enum eMargin {
		None,
		In,
		Out,
	}

	public static Rect GetScreenRect(eMargin type) {
		Rect ret = new Rect();
		Vector2 min = Camera.main.ViewportToWorldPoint(new Vector2(0, 0));
		Vector2 max = Camera.main.ViewportToWorldPoint(new Vector2(1, 1));
		ret.xMin = min.x;
		ret.yMin = min.y;
		ret.xMax = max.x;
		ret.yMax = max.y;

		switch(type) {
		case eMargin.None:
			break;
		case eMargin.In:
			ret.xMin += MARGIN;
			ret.yMin += MARGIN;
			ret.xMax -= MARGIN;
			ret.yMax -= MARGIN;
			break;
		case eMargin.Out:
			ret.xMin -= MARGIN;
			ret.yMin -= MARGIN;
			ret.xMax += MARGIN;
			ret.yMax += MARGIN;
			break;
		}
		return ret;
	}

	public static bool IsOut(Vector2 pos, float nMargin) {

		Vector2 min = Camera.main.ViewportToWorldPoint(new Vector2(0, 0));
		Vector2 max = Camera.main.ViewportToWorldPoint(new Vector2(1, 1));
		min.x -= nMargin;
		min.y -= nMargin;
		max.x += nMargin;
		max.y += nMargin;
		if(pos.x < min.x) { return true; }
		if(pos.y < min.y) { return true; }
		if(pos.x > max.x) { return true; }
		if(pos.y > max.x) { return true; }
		return false;
	}

	public static Sprite GetSprite(string fileName, string spriteName) {
		Sprite[] sprites = Resources.LoadAll<Sprite>(fileName);
		return System.Array.Find<Sprite>(sprites, (sprite) => sprite.name.Equals(spriteName));
	}

}
