/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.Serializable;
import twitter4j.TwitterException;
import twitter4j.http.OAuthToken;
import twitter4j.internal.http.HttpResponse;

public class AccessToken
extends OAuthToken
implements Serializable {
    private static final long serialVersionUID = -8344528374458826291L;
    private String screenName;
    private int userId;

    AccessToken(HttpResponse res) throws TwitterException {
        this(res.asString());
    }

    AccessToken(String str) {
        super(str);
        this.screenName = this.getParameter("screen_name");
        String sUserId = this.getParameter("user_id");
        if (sUserId != null) {
            this.userId = Integer.parseInt(sUserId);
        }
    }

    public AccessToken(String token, String tokenSecret) {
        super(token, tokenSecret);
    }

    public String getScreenName() {
        return this.screenName;
    }

    public int getUserId() {
        return this.userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessToken)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        if (this.userId != that.userId) {
            return false;
        }
        return !(this.screenName != null ? !this.screenName.equals(that.screenName) : that.screenName != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.screenName != null ? this.screenName.hashCode() : 0);
        result = 31 * result + this.userId;
        return result;
    }

    public String toString() {
        return "AccessToken{screenName='" + this.screenName + '\'' + ", userId=" + this.userId + '}';
    }

    public /* synthetic */ String getParameter(String x0) {
        return super.getParameter(x0);
    }

    public /* synthetic */ String getTokenSecret() {
        return super.getTokenSecret();
    }

    public /* synthetic */ String getToken() {
        return super.getToken();
    }
}

