/*
 * Copyright (C) 2009 The Android Open Source Project
 * Copyright (C) 2011 Sony Ericsson Mobile Communications AB.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * NOTE: This file has been modified by Sony Ericsson Mobile Communications AB.
 * Modifications are licensed under the License.
 */

#include <media/mediascanner.h>

#include <utils/StringArray.h>

#include "autodetect.h"

namespace android {

MediaScannerClient::MediaScannerClient()
    :   mLocaleEncoding(kEncodingNone)
{
}

MediaScannerClient::~MediaScannerClient()
{
}

void MediaScannerClient::setLocale(const char* locale)
{
    if (!locale) return;

    if (!strncmp(locale, "ja", 2))
        mLocaleEncoding = kEncodingShiftJIS;
    else if (!strncmp(locale, "ko", 2))
        mLocaleEncoding = kEncodingEUCKR;
    else if (!strncmp(locale, "zh", 2)) {
        if (!strcmp(locale, "zh_CN")) {
            // simplified chinese for mainland China
            mLocaleEncoding = kEncodingGBK;
        } else {
            // assume traditional for non-mainland Chinese locales (Taiwan, Hong Kong, Singapore)
            mLocaleEncoding = kEncodingBig5;
        }
    }
}

void MediaScannerClient::beginFile()
{
}

bool MediaScannerClient::addStringTag(const char* name, const char* value)
{
    // The local transcoding has been moved to ID3.cpp in the stagefright,
	// which was placed here in the original implementation.
	// The original implementation has 2 problems:
	//  1.) A local encoded string was forcely converted to UTF-8 wrongly in ID3.cpp.
	//      Detecting local encoding type against forcely converted strings
	//      does not make any sense.
    //  2.) Because it is theoretically hard to detect UTF-8 and other local encodings
	//      with limited strings, it caused wrong transcoding that
	//      a true UTF-8 string will be converted to UTF-8 as a local-encoded string.
	//      a UTF-8 string should be handled as a string unnecessary to be converted.
    return handleStringTag(name, value);
}

void MediaScannerClient::endFile()
{
}

}  // namespace android

