/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.calllogplugin;

import com.sonyericsson.eventstream.calllogplugin.utilities.CallLogPluginTestCase;

import android.content.ContentResolver;
import android.net.Uri;
import android.provider.ContactsContract;
import android.provider.CallLog.Calls;

public class FContactChangeTests extends CallLogPluginTestCase {

    String dummyNumber = "+46112233";
    String dummyName = "Dummy Name";

    String dummyContactUri = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        registerPlugin();
        sleep(2);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (dummyContactUri != null) {
            removeContact(dummyContactUri);
        }
    }

    public void testRemoveCallLogItem() {

        int call1 = addCall(Calls.MISSED_TYPE, dummyNumber, dummyName);
        int call2 = addCall(Calls.MISSED_TYPE, dummyNumber, dummyName);
        int call3 = addCall(Calls.MISSED_TYPE, dummyNumber, dummyName);
        sleep(3);
        assertEquals(3, getNumberOfEvents());
        removeCall(call1);
        sleep(7);
        assertNull(getEventFromCallId(call1));
        assertNotNull(getEventFromCallId(call2));
        assertNotNull(getEventFromCallId(call3));
        removeCall(call3);
        sleep(7);
        assertNull(getEventFromCallId(call1));
        assertNotNull(getEventFromCallId(call2));
        assertNull(getEventFromCallId(call3));
        removeCall(call2);
        sleep(7);
        assertNull(getEventFromCallId(call1));
        assertNull(getEventFromCallId(call2));
        assertNull(getEventFromCallId(call3));
    }

    public void testAddContact() {
        deleteCalls(dummyNumber);
        int callId = addCall(Calls.MISSED_TYPE, dummyNumber, null);
        sleep(3);
        Event e = getEventFromCallId(callId);
        assertNotNull(e);
        assertEquals(callId, Integer.parseInt(e.eventKey));
        Friend f = getFriendFromFriendKey(e.friendKey);
        assertNotNull(f);
        assertNull(f.contactUri); // Should be null check
        dummyContactUri = addContact(dummyName, dummyNumber);
        sleep(10);
        f = getFriendFromFriendKey(e.friendKey);
        assertNotNull(f);
        assertEquals(dummyName, f.displayName);
        assertEquals(dummyNumber, f.friendKey);
        assertEquals(dummyContactUri, f.contactUri);
    }

    public void testUpdateContactName() {
        ContentResolver cr = getContext().getContentResolver();
        testAddContact();
        String updatedName = "Bridge Testman";
        String rawContactUri = findRawContactFromName(dummyName);
        changeContactName(rawContactUri, updatedName);
        sleep(10);
        Friend f = getFriend(dummyNumber);
        assertNotNull(f);
        assertEquals(ContactsContract.RawContacts.getContactLookupUri(cr, Uri.parse(rawContactUri)),
                     ContactsContract.Contacts.getLookupUri(cr, Uri.parse(f.contactUri)));
        assertEquals(updatedName, f.displayName);
    }

    public void testUpdateContactPhone() {
        testAddContact();
        String updatedPhone = "+81112233";
        String rawContactUri = findRawContactFromName(dummyName);
        changePhoneNumber(rawContactUri, updatedPhone);
        sleep(10);
        Friend f = getFriend(dummyNumber);
        assertNotNull(f);
        assertNull(f.contactUri);
        assertEquals(dummyNumber, f.friendKey);
    }
}
