/*  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.esdatasourceplugin;

import com.sonyericsson.esdatasourceplugin.EventStreamContentProvider.EventColumns;
import com.sonyericsson.esdatasourceplugin.EventStreamContentProvider.FriendColumns;
import com.sonyericsson.esdatasourceplugin.EventStreamContentProvider.PluginColumns;
import com.sonyericsson.esdatasourceplugin.EventStreamContentProvider.SourceColumns;

import android.app.Activity;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;


public class DataSourceActivity extends Activity {
    protected static final String LOG_TAG = "TS Datasource plugin";

    private static final int PROFILE_IMAGE_SMALL = 50;
    private static final int PROFILE_IMAGE_MIDDLE = 170;
    private static final int PROFILE_IMAGE_LARGE = 480;
    private static int INDEX = 0;

    private static final String FRIEND_KEY = "friend";

    private long mSourceId;

    private String mRawContactUri;

    private Uri mContactUri;

    private int mFriendKey = 0;

    private static int mEventKey = 0;

    private ArrayList<Uri> uriList;

    private long mDataSet4SourceId;

    private String mDataSet4LookupKey;

    private String mDataSet4FriendKey;

    private List<EventProducer> mEventProducers;

    private List<EventConsumer> mEventConsumers;

    private EventStreamContentObserver mEventStreamObserver;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        uriList = new ArrayList<Uri>();
        mEventProducers = new ArrayList<EventProducer>();
        mEventConsumers = new ArrayList<EventConsumer>();
    }

    public void onAddDataSet1(View view) {
        if (view.getId() == R.id.addButton1) {
            Log.d(LOG_TAG, "Clicked addButton1");
            addDataSet1();
        }
    }

    public void onDeleteDataSet1(View view) {
        if (view.getId() == R.id.deleteButton1) {
            Log.d(LOG_TAG, "Clicked deleteButton1");
            deleteDataSet1();
        }
    }

    public void onAddDataSet2(View view) {
        if (view.getId() == R.id.addButton2) {
            Log.d(LOG_TAG, "Clicked addButton2");
            addDataSet2();
        }
    }

    public void onDeleteDataSet2(View view) {
        if (view.getId() == R.id.deleteButton2) {
            Log.d(LOG_TAG, "Clicked deleteButton2");
            deleteDataSet1();
        }
    }

    public void onAddDataSet3(View view) {
        if (view.getId() == R.id.addButton3) {
            Log.d(LOG_TAG, "Clicked addButton3");
            addDataSet3();
        }
    }

    public void onDeleteDataSet3(View view) {
        if (view.getId() == R.id.deleteButton3) {
            Log.d(LOG_TAG, "Clicked deleteButton3");
            deleteDataSet1();
        }
    }

    public void onAddDataSet4(View view) {
        if (view.getId() == R.id.addButton4) {
            Log.d(LOG_TAG, "Clicked addButton4");
            addDataSet4();
        }
    }

    public void onStopGenerateEvent(View view) {
        if (view.getId() == R.id.stopGenerateEventButton) {
            stopAsynchronousEvents();
        }
    }

    public void onGenerateEvent(View view) {
        if (view.getId() == R.id.generateEventButton) {
            generateAsynchronousEvents();
        }
    }

    public void onQueryDatabase(View view) {
        if (view.getId() == R.id.queryDatabaseButton) {
            startQuering();
        }
    }

    public void onStopQueryDatabase(View view) {
        if (view.getId() == R.id.stopQueryButton) {
            stopQuering();
        }
    }

    /**
     * Start listening to cursor changes and data set changes...
     *
     * @param view
     */
    public void onStartListenerButton(View view) {
        if (mEventStreamObserver == null) {
            mEventStreamObserver = new EventStreamContentObserver(new Handler());
            mEventStreamObserver.start();
        }
    }

    public void onStopListeningButton(View view) {
        if (mEventStreamObserver != null) {
            mEventStreamObserver.stop();
        }
    }

    class CursorListener {
        Cursor mCursor;
        CursorContentObserver mContentObserver;
        CursorSetObserver mCursorSetObserver;

        class CursorContentObserver extends ContentObserver {
            public CursorContentObserver(Handler handler) {
                super(handler);
            }

            @Override
            public void onChange(boolean selfChange) {
                android.util.Log.d(LOG_TAG, "Cursor adapter onchange!");
            }
        }
        class CursorSetObserver extends DataSetObserver {
            @Override
            public void onChanged() {
                android.util.Log.d(LOG_TAG, "DataSetObserver onchange!");
            }
            @Override
            public void onInvalidated() {
                android.util.Log.d(LOG_TAG, "DataSetObserver invalidate!");
            }
        }

        public CursorListener() {
            mCursorSetObserver = new CursorSetObserver();
            mContentObserver = new CursorContentObserver(new Handler());
        }

        public void start() {
            if (mCursor == null) {
                mCursor = DBUtilities.getInstance().querySplineEventCursor(getApplicationContext(), "");
                mCursor.registerContentObserver(mContentObserver);
                mCursor.registerDataSetObserver(mCursorSetObserver);
            }
        }

        public void stop() {
            if (mCursor != null) {
                mCursor.close();
                mCursor.unregisterContentObserver(mContentObserver);
                mCursor.unregisterDataSetObserver(mCursorSetObserver);
            }
        }
    }

    class EventStreamContentObserver extends ContentObserver {
        public EventStreamContentObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean selfChange) {
            android.util.Log.d(LOG_TAG, "Data set changed!");
        }

        public void start() {
            getContentResolver().registerContentObserver(EventStreamContentProvider.Uris.BASE_URI, true,
                    mEventStreamObserver);
        }

        public void stop() {
            getContentResolver().unregisterContentObserver(mEventStreamObserver);
        }
    }

    public class EventConsumer {
        private long mStartDelay = -1;
        private long mExecutionDelay = -1;
        private Timer mTimer = new Timer("EventReader");
        private EventConsumerEngine mConsumerTask = null;
        private int mRunId = 0;
        private String mName = null;

        public EventConsumer(String name, long startDelay, long delay) {
            mStartDelay = startDelay;
            mExecutionDelay = delay;
            mName = name;
        }

        public void setup() {
            mConsumerTask = new EventConsumerEngine();
        }

        public void start() {
            mTimer.schedule(mConsumerTask, mStartDelay, mExecutionDelay);
        }

        public void stop() {
            mTimer.cancel();
            mTimer.purge();
        }

        public class EventConsumerEngine extends TimerTask {
            public EventConsumerEngine() {

            }

            public void run() {
                int function = new Random().nextInt(10);
                Cursor cursor = null;
                long startTime = System.currentTimeMillis();

                android.util.Log.d(LOG_TAG, "Running query:" + function + " for " + mName + " run:" + mRunId);

                try {
                    switch (function) {
                        case 0:
                            cursor = DBUtilities.getInstance().queryEnabledSourceCursor(getApplicationContext());
                            break;
                        case 1:
                            cursor = DBUtilities.getInstance().querySettingsPluginCursor(getApplicationContext());
                            break;
                        case 2:
                            cursor = DBUtilities.getInstance().queryStatusUpdatePluginCursor(getApplicationContext());
                            break;
                        case 3:
                            cursor = DBUtilities.getInstance().querySettingsPluginCursor(getApplicationContext());
                            break;
                        case 4:
                            cursor = DBUtilities.getInstance().queryFriendCursor(getApplicationContext(), null, null, null);
                            break;
                        default:
                            cursor = DBUtilities.getInstance().querySplineEventCursor(getApplicationContext(), "");
                            break;
                    }

                    if (cursor != null) {
                        cursor.moveToFirst();
                        cursor.getCount();
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                long endTime = System.currentTimeMillis();

                if ((startTime + 1000) <= endTime) {
                    android.util.Log.e(LOG_TAG,
                            "Query in test app takes to long (" + (endTime - startTime) + ") for " + mName + " run:" + mRunId,
                            new Exception("ANR"));
                }

                mRunId++;
            }
        }
    }

    public class EventProducer {
        private long mStartDelay = -1;
        private long mInsertDelay = -1;
        private int mMaxEventCount = 100;
        private Timer mTimer = null;
        private EventProducerEngine mProducerTask = null;
        private int mStoredEvents = 0;
        private int mMinEventCount = 0;
        private int mRunId = 0;
        private String mName = null;
        private long mSourceId = 0;

        public EventProducer(String name, long startDelay, long delay, int maxEventCount) {
            mStartDelay = startDelay;
            mInsertDelay = delay;
            mMaxEventCount = maxEventCount;
            mTimer = new Timer("EventGenerator");
            mProducerTask = new EventProducerEngine();
            mStoredEvents = 0;
            mMinEventCount = maxEventCount / 2;
            mName = name;
        }

        /**
         * Register plug-in/source
         */
        private void setup() {
            addPlugin();
            final String source1 = "AutoEvents" + INDEX++;

            mSourceId = addSource(source1);
        }

        public void start() {
            mTimer.schedule(mProducerTask, mStartDelay, mInsertDelay);
        }

        public void stop() {
            mTimer.cancel();
            mTimer.purge();
        }

        private class EventProducerEngine extends TimerTask {
            public void run() {
                int nbrOfEvents = new Random().nextInt(mMaxEventCount);

                if (nbrOfEvents < mMinEventCount) {
                    nbrOfEvents = mMinEventCount;
                }
                ContentValues values[] = new ContentValues[nbrOfEvents];

                for (int index = 0; index < nbrOfEvents; index++) {
                    values[index] = addGeneratedEvent("friend-key-" + mStoredEvents + index,
                            "title:" + mStoredEvents + index,
                            "message:" + mStoredEvents + index,
                            Integer.toString(R.drawable.miranda_small),
                            EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE,
                            mSourceId, null, null);
                }
                mStoredEvents += nbrOfEvents;

                android.util.Log.d(LOG_TAG, "XXXXAbout to store " + nbrOfEvents + " events in " + mName + " run:" + mRunId);

                storeEvent(getApplicationContext(), values);

                android.util.Log.d(LOG_TAG, "Storing " + nbrOfEvents + " events in " + mName + " run:" + mRunId);

                mRunId++;
            }

            private void storeEvent(Context context, ContentValues values[]) {
                int count = getContentResolver().bulkInsert(
                        EventStreamContentProvider.Uris.EVENTS_URI,
                        values);
                if (count != values.length) {
                    android.util.Log.d(LOG_TAG, "Failed to store events:" + count + " was stored but " + values.length + " was wanted");

                    runOnUiThread(new Runnable() {
                       public void run() {
                           Toast toast = Toast.makeText(getApplicationContext(), "Couldn't insert events:" , Toast.LENGTH_SHORT);
                           toast.setGravity(Gravity.CENTER, 0, 0);
                           toast.show();
                       }
                    });
                }
            }

            private ContentValues addGeneratedEvent(String friendKey, String title, String message,
                    String backgroundImage, int outgoing, long sourceId, String extraIcon, String layout_type) {
                ContentValues value = new ContentValues();

                value.put(EventColumns.FRIEND_KEY, friendKey);
                value.put(EventColumns.TITLE, title);
                value.put(EventColumns.MESSAGE, message);
                if (backgroundImage != null) {
                    value.put(EventColumns.IMAGE_URI, "android.resource://com.sonyericsson.esdatasourceplugin/"
                            + backgroundImage);
                }
                value.put(EventColumns.PERSONAL, "1");
                value.put(EventColumns.OUTGOING, Integer.toString(outgoing));
                value.put(EventColumns.HANDLED_TYPE, "0");
                value.put(EventColumns.PUBLISHED_TIME, new Date().getTime());
                value.put(EventColumns.SOURCE_ID, Long.toString(sourceId));
                value.put(EventColumns.EVENT_KEY, mEventKey++);
                value.put(EventColumns.LAYOUT_TYPE, layout_type);
                if (extraIcon != null) {
                    value.put(EventColumns.STATUS_ICON_URI, "android.resource://com.sonyericsson.esdatasourceplugin/"
                        + extraIcon);
                }

                return value;
            }
        }
    }

    private void generateAsynchronousEvents() {
        EventProducer eventProducer = new EventProducer("Producer" + INDEX++, 1 * 1000, 1 * 1000 * 3, 1000);

        eventProducer.setup();
        eventProducer.start();
        mEventProducers.add(eventProducer);
    }

    private void startQuering() {
        EventConsumer eventConsumer = new EventConsumer("Consumer" + INDEX++, 3 * 1000, 500);

        eventConsumer.setup();
        eventConsumer.start();
        mEventConsumers.add(eventConsumer);
    }

    private void stopQuering() {
        if (mEventConsumers.size() > 0) {
            EventConsumer consumer = mEventConsumers.remove(mEventConsumers.size() - 1);

            if (consumer != null) {
                consumer.stop();
            }
        }
    }

    private void stopAsynchronousEvents() {
        if (mEventProducers.size() > 0) {
            EventProducer eventProducer = mEventProducers.remove(mEventProducers.size() - 1);

            if (eventProducer != null) {
                eventProducer.stop();
            }
        }
    }

    private void addDataSet4() {

        if(addPlugin() == true) {
            final String source = "AddEvent";
            final String firstName = "Mira";
            final String lastName = "Johanss";
            final String displayName = firstName + " " + lastName;
            mDataSet4SourceId = addSource(source);
            mDataSet4LookupKey = addContact(firstName, lastName, source, R.drawable.miranda_contact);
            mDataSet4FriendKey = addFriend(mDataSet4SourceId, mRawContactUri, displayName, Integer.toString(R.drawable.miranda_small));
        }
        Thread t = new Thread(new Runnable() {

            public void run() {
                try {
                    Thread.sleep(7000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                uriList.add(addEvent(mDataSet4FriendKey,
                        mDataSet4SourceId,
                        "Add event title" + mEventKey,
                        "Add event message",
                        null,
                        0,
                        null));
                uriList.add(addEvent(mDataSet4FriendKey,
                        mDataSet4SourceId,
                        "Add event title" + mEventKey,
                        "Add event message",
                        null,
                        0,
                        null));
                uriList.add(addEvent(mDataSet4FriendKey,
                        mDataSet4SourceId,
                        "Add event title" + mEventKey,
                        "Add event message",
                        null,
                        0,
                        null));
            }
        });
        t.run();
    }

    public void onDeleteDataSet4(View view) {
        if (view.getId() == R.id.deleteButton4) {
            Log.d(LOG_TAG, "Clicked deleteButton4");
            deleteDataSet4();
        }
    }

    private void deleteDataSet4() {
        Thread t = new Thread(new Runnable() {

            public void run() {
                try {
                    Thread.sleep(7000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if(!uriList.isEmpty()) {
                    getContentResolver().delete(uriList.remove(0), null, null);
                }
            }
        });
        t.run();
    }

    public void onAddDataSet5(View view) {
        if (view.getId() == R.id.addButton5) {
            Log.d(LOG_TAG, "Clicked addButton5");
            addDataSet5();
        }
    }

    public void onDeleteDataSet5(View view) {
        if (view.getId() == R.id.deleteButton5) {
            Log.d(LOG_TAG, "Clicked deleteButton5");
            deleteDataSet1();
        }
    }

    /**
     * Adds one contact and three services (Calls, Messaging, Facebook) plus
     * some events for each service.
     *
     * Note: To simplify things the three services belongs to the same plugin
     */
    private void addDataSet1() {
        if(addPlugin() == true) {
            final String source1 = "Facebook";
            final String firstName = "Miranda";
            final String lastName = "Johansson";
            final String displayName = firstName + " " + lastName;
            mSourceId = addSource(source1);
            mRawContactUri = addContact(firstName, lastName, source1, R.drawable.miranda_contact);
            String friendKey = addFriend(mSourceId, mRawContactUri, displayName, Integer.toString(R.drawable.miranda_small));
            addEvent(friendKey, mSourceId, null, "Niiiice weather today!!! Let's hope for some fun in the sun....", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "Driving to Norway over the weekend. Hoping to see some nice Fjords, so I also hope the weather will be nice.", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "time to make the best of this beautiful outdoor weekend.", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "One new photo", Integer.toString(R.drawable.norway), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "Catched a terrible cold and have high fever. Sneezing and freezing.... Needs some strong medicine... Does anyone knows a good doctor???", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "Holiday's over, time to go to work. Yaiiike!!!!", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "My neighbour is killing me", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);

            /*
            final String source2 = "Email";
            mSourceId = addSource(source2);
            friendId = addFriend(mSourceId, mLookupKey, displayName, null);
            addEvent(friendId, mSourceId, "Norway", "Hello neighbour,\n" +
                    "Would you be kind and take care of my flowers, I will stay here a little bit longer." +
                    "\nAttached is a breathtaking picture from Hardangervidda." +
                    "\n\n/ Samuel", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, Integer.toString(R.drawable.email_attachment_small));
            addEvent(friendId, mSourceId, "Re: Dinner at Friday", "Sounds nice, count me in. \n\nRoy", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            */

            final String source3 = "Calls";
            mSourceId = addSource(source3);
            friendKey = addFriend(mSourceId, mRawContactUri, displayName, null);
            addEvent(friendKey, mSourceId, null, "+46730436689", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, Integer.toString(R.drawable.ic_call_log_header_missed_call_icn));
            addEvent(friendKey, mSourceId, null, "+4670010010", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_TRUE, Integer.toString(R.drawable.ic_call_log_header_outgoing_call_icn));
            addEvent(friendKey, mSourceId, null, "+464690510", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, Integer.toString(R.drawable.ic_call_log_header_incoming_call_icn));

            final String source4 = "Messages";
            mSourceId = addSource(source4, 1);
            friendKey = addFriend(mSourceId, mRawContactUri, displayName, null);
            addEvent(friendKey, mSourceId, null, "Hi! When will you be home?", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null, "received");
            addEvent(friendKey, mSourceId, null, "As soon as possible...", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_TRUE, null, "sent");
            addEvent(friendKey, mSourceId, null, "Great, the dinner is ready.", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null, "received");
            addEvent(friendKey, mSourceId, null, "Perfect, I could eat a cow, hope you've cooked a lot.", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_TRUE, null, "sent");
            addEvent(friendKey, mSourceId, null, "You bet", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null, "received");

        }
    }

    /**
     * Adds events with different combinations of title, message, image, icon etc
     */
    private void addDataSet2() {
        if(addPlugin() == true) {
            final String source1 = "Mixed";
            final String firstName = "Maurits";
            final String lastName = "Johansson";
            final String displayName = firstName + " " + lastName;
            mSourceId = addSource(source1);
            mRawContactUri = addContact(firstName, lastName, source1, R.drawable.maurits_contact);
            String friendKey = addFriend(mSourceId, mRawContactUri, displayName, Integer.toString(R.drawable.maurits_small));
            addEvent(friendKey, mSourceId, null, null, null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, null, Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "Just a plain message", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "No title, just text and picture.", Integer.toString(R.drawable.maurits_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "A title", "A message and a picture", Integer.toString(R.drawable.maurits_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "A title and a picture", null, Integer.toString(R.drawable.maurits_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "A title", "And a message text, no picture.", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "Just a veeeeeerrrrrry loooonnnnggg title", null, null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "wwwwwwwww wwwwwwwww wwwwwwwww wwwwwwwww wwwwwwwww wwwwwwwww wwwwwwwww wwwwwwwww wwwwwwwww wwwwwwwww wwwwwwwww ", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "iiiiiiiii lllllllll iiiiiiiii lllllllll iiiiiiiii lllllllll iiiiiiiii lllllllll iiiiiiiii lllllllll iiiiiiiii lllllllll", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);

            addEvent(friendKey, mSourceId, null, null, null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, null, Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "Just a plain message", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "No title, just text and picture.", Integer.toString(R.drawable.maurits_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "A title", "A message and a picture", Integer.toString(R.drawable.maurits_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "A title and a picture", null, Integer.toString(R.drawable.maurits_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "A title", "And a message text, no picture.", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "Just a veeeeeerrrrrry loooonnnnggg title", null, null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);

            addEvent(friendKey, mSourceId, null, null, null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, null, Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "Just a plain message", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, null, "No title, just text and picture.", Integer.toString(R.drawable.maurits_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "A title", "A message and a picture", Integer.toString(R.drawable.maurits_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "A title and a picture", null, Integer.toString(R.drawable.maurits_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "A title", "And a message text, no picture.", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            addEvent(friendKey, mSourceId, "Just a veeeeeerrrrrry loooonnnnggg title", null, null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
        }
    }

    /**
     * Adds one service and three non-linked friends plus a couple of events
     */
    private void addDataSet3() {
        if(addPlugin() == true) {
            {
                final String source1 = "Service 1";
                final String firstName = "Friend";
                final String lastName = "One";
                final String displayName = firstName + " " + lastName;
                mSourceId = addSource(source1);
                String friendKey = addFriend(mSourceId, null, displayName, Integer.toString(R.drawable.maurits_small));
                addEvent(friendKey, mSourceId, null, displayName + " message 1", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
                addEvent(friendKey, mSourceId, null, displayName + " message 2", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
                addEvent(friendKey, mSourceId, null, displayName + " message 3", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            }
            {
                final String firstName = "Friend";
                final String lastName = "Two";
                final String displayName = firstName + " " + lastName;
                String friendKey = addFriend(mSourceId, null, displayName, Integer.toString(R.drawable.maurits_contact));
                addEvent(friendKey, mSourceId, null, displayName + " message 1", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
                addEvent(friendKey, mSourceId, null, displayName + " message 2", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
                addEvent(friendKey, mSourceId, null, displayName + " message 3", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            }
            {
                final String firstName = "Friend";
                final String lastName = "Three";
                final String displayName = firstName + " " + lastName;
                String friendKey = addFriend(mSourceId, null, displayName, null);
                addEvent(friendKey, mSourceId, null, displayName + " message 1", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
                addEvent(friendKey, mSourceId, null, displayName + " message 2", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
                addEvent(friendKey, mSourceId, null, displayName + " message 3", null, EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            }


        }
    }

    /**
     * Adds several contacts with different size images. One service added per contact.
     */
    private void addDataSet5() {
        if(addPlugin() == true) {
            {
                final String source1 = "Facebook";
                final String firstName = "Small image";
                final String lastName = ", bright";
                final String displayName = firstName + " " + lastName;

                Bitmap bitmap = getBitmap(R.drawable.miranda_small, PROFILE_IMAGE_SMALL);
                mRawContactUri = addContact(firstName, lastName, source1, bitmap);

                mSourceId = addSource(source1);
                String friendKey = addFriend(mSourceId, mRawContactUri, displayName, Integer.toString(R.drawable.miranda_small));
                addEvent(friendKey, mSourceId, null, "Event1", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            }

            {
                final String source1 = "Facebook";
                final String firstName = "Middle image";
                final String lastName = ", bright";
                final String displayName = firstName + " " + lastName;

                Bitmap bitmap = getBitmap(R.drawable.miranda_contact, PROFILE_IMAGE_MIDDLE);
                mRawContactUri = addContact(firstName, lastName, source1, bitmap);

                mSourceId = addSource(source1);
                String friendKey = addFriend(mSourceId, mRawContactUri, displayName, Integer.toString(R.drawable.miranda_small));
                addEvent(friendKey, mSourceId, null, "Event1", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            }

            {
                final String source1 = "Facebook";
                final String firstName = "Large image";
                final String lastName = ", bright";
                final String displayName = firstName + " " + lastName;

                Bitmap bitmap = getBitmap(R.drawable.miranda_contact, PROFILE_IMAGE_LARGE);
                mRawContactUri = addContact(firstName, lastName, source1, bitmap);

                mSourceId = addSource(source1);
                String friendKey = addFriend(mSourceId, mRawContactUri, displayName, Integer.toString(R.drawable.miranda_small));
                addEvent(friendKey, mSourceId, null, "Event1", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            }

            {
                final String source1 = "Facebook";
                final String firstName = "Small image";
                final String lastName = ", dark";
                final String displayName = firstName + " " + lastName;

                Bitmap bitmap = getBitmap(R.drawable.maurits_small, PROFILE_IMAGE_SMALL);
                mRawContactUri = addContact(firstName, lastName, source1, bitmap);

                mSourceId = addSource(source1);
                String friendKey = addFriend(mSourceId, mRawContactUri, displayName, Integer.toString(R.drawable.miranda_small));
                addEvent(friendKey, mSourceId, null, "Event1", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            }

            {
                final String source1 = "Facebook";
                final String firstName = "Middle image";
                final String lastName = ", dark";
                final String displayName = firstName + " " + lastName;

                Bitmap bitmap = getBitmap(R.drawable.maurits_contact, PROFILE_IMAGE_MIDDLE);
                mRawContactUri = addContact(firstName, lastName, source1, bitmap);

                mSourceId = addSource(source1);
                String friendKey = addFriend(mSourceId, mRawContactUri, displayName, Integer.toString(R.drawable.miranda_small));
                addEvent(friendKey, mSourceId, null, "Event1", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            }

            {
                final String source1 = "Facebook";
                final String firstName = "Large image";
                final String lastName = ", dark";
                final String displayName = firstName + " " + lastName;

                Bitmap bitmap = getBitmap(R.drawable.maurits_contact, PROFILE_IMAGE_LARGE);
                mRawContactUri = addContact(firstName, lastName, source1, bitmap);

                mSourceId = addSource(source1);
                String friendKey = addFriend(mSourceId, mRawContactUri, displayName, Integer.toString(R.drawable.miranda_small));
                addEvent(friendKey, mSourceId, null, "Event1", Integer.toString(R.drawable.miranda_small), EventStreamContentProvider.EVENT_OUTGOING_FLAG_FALSE, null);
            }
        }
    }

    private Bitmap getBitmap (int resource, int width) {
        Bitmap bitmap = BitmapFactory.decodeResource(
                getApplicationContext().getResources(), resource);
        if (bitmap != null) {
            float scale = (float)width / (float)bitmap.getWidth();
            int scaleToWidth = (int)((float)bitmap.getWidth() * scale);
            int scaleToHeight = (int)((float)bitmap.getHeight() * scale);
            bitmap = Bitmap.createScaledBitmap(bitmap, scaleToWidth, scaleToHeight, false);
        }
        return bitmap;
    }

    private String addContact(String firstName, String lastName, String source, int drawableId) {
        TestContact testContact = new TestContact(
                "com.sonyericsson.esdatasourceplugin", source, firstName, lastName,
                getContentResolver());

        testContact.setRingtone(this.getApplicationContext());
        testContact.setNotes();
        testContact.setNumbers();
        testContact.setEmail();
        testContact.setIM(8);
        testContact.setPostal();
        testContact.setOrganization();
        testContact.setPhoto(getApplicationContext(), drawableId);
        testContact.setFavorite();

        mContactUri = testContact.getUri();
        Uri rawContactUri = testContact.getRawUri();

        return rawContactUri.toString();

//        ContentValues values = new ContentValues();
//        values.put(RawContacts.ACCOUNT_NAME, source);
//        values.put(RawContacts.ACCOUNT_TYPE, "com.sonyericsson.esdatasourceplugin");
//        Uri rawContactUri = getContentResolver().insert(RawContacts.CONTENT_URI, values);
//        long rawContactId = ContentUris.parseId(rawContactUri);
//        Uri lookupUri = ContactsContract.RawContacts.getContactLookupUri(getContentResolver(), rawContactUri);
//
//        // Set name
//        values.clear();
//        values.put(Data.RAW_CONTACT_ID, rawContactId);
//        values.put(StructuredName.DISPLAY_NAME, name);
//        values.put(Data.MIMETYPE, CommonDataKinds.StructuredName.CONTENT_ITEM_TYPE);
//        Uri uri = getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
//
//        // Set photo
//        values.clear();
//        ByteArrayOutputStream stream = new ByteArrayOutputStream();
//        BitmapDrawable bitmapDrawable = (BitmapDrawable)getResources().getDrawable(
//                drawableId);
//        bitmapDrawable.getBitmap().compress(Bitmap.CompressFormat.JPEG, 75, stream);
//        values.put(Data.RAW_CONTACT_ID, rawContactId);
//        values.put(Data.MIMETYPE, CommonDataKinds.Photo.CONTENT_ITEM_TYPE);
//        values.put(CommonDataKinds.Photo.PHOTO, stream.toByteArray());
//        uri = getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
    }


    private String addContact(String firstName, String lastName, String source, Bitmap bitmap) {
        TestContact testContact = new TestContact(
                "com.sonyericsson.esdatasourceplugin", source, firstName, lastName,
                getContentResolver());

        testContact.setRingtone(this.getApplicationContext());
        testContact.setNotes();
        testContact.setNumbers();
        testContact.setEmail();
        testContact.setIM(8);
        testContact.setPostal();
        testContact.setOrganization();
        testContact.setPhoto(bitmap);
        testContact.setFavorite();

        mContactUri = testContact.getUri();
        Uri rawContactUri = testContact.getRawUri();

        return rawContactUri.toString();
    }

    private ContentValues getContentValueEvent(String friendKey, long sourceId, String title,
            String message, String backgroundImage, int outgoing, String extraIcon, String layout_type) {
        ContentValues regVal = new ContentValues();
        regVal.put(EventColumns.FRIEND_KEY, friendKey);
        regVal.put(EventColumns.TITLE, title);
        regVal.put(EventColumns.MESSAGE, message);
        if(backgroundImage != null) {
            regVal.put(EventColumns.IMAGE_URI, "android.resource://com.sonyericsson.esdatasourceplugin/"
                    + backgroundImage);
        }
        regVal.put(EventColumns.PERSONAL, "1");
        regVal.put(EventColumns.OUTGOING, Integer.toString(outgoing));
        regVal.put(EventColumns.HANDLED_TYPE, "0");
        regVal.put(EventColumns.PUBLISHED_TIME, new Date().getTime());
        regVal.put(EventColumns.SOURCE_ID, Long.toString(sourceId));
        regVal.put(EventColumns.EVENT_KEY, mEventKey++);
        regVal.put(EventColumns.LAYOUT_TYPE, layout_type);
        if(extraIcon != null) {
            regVal.put(EventColumns.STATUS_ICON_URI, "android.resource://com.sonyericsson.esdatasourceplugin/"
                + extraIcon);
        }
        return regVal;
    }

    private Uri addEvent(String friendKey, long sourceId, String title,
            String message, String backgroundImage, int outgoing, String extraIcon, String layout_type) {
        ContentValues regVal = getContentValueEvent(friendKey, sourceId, title,
            message, backgroundImage, outgoing, extraIcon, layout_type);
        Uri uri = getContentResolver().insert(
                EventStreamContentProvider.Uris.EVENTS_URI,
                regVal);

        return uri;
    }

    private Uri addEvent(String friendKey, long sourceId, String title,
            String message, String backgroundImage, int outgoing, String extraIcon) {
        return addEvent(friendKey, sourceId, title, message, backgroundImage, outgoing, extraIcon, null);
    }

    private String addFriend(long sourceId, String rawContactUri, String name, String drawable) {
        String friendKey = FRIEND_KEY + "'" + mFriendKey +"'";
        mFriendKey++;
        ContentValues regVal = new ContentValues();
        regVal.put(FriendColumns.CONTACTS_REFERENCE, rawContactUri);
        regVal.put(FriendColumns.DISPLAY_NAME, name);
        regVal.put(FriendColumns.FRIEND_KEY, friendKey);
        if(drawable != null) {
            regVal.put(FriendColumns.PROFILE_IMAGE_URI, "android.resource://com.sonyericsson.esdatasourceplugin/"
                    + drawable);
        }
        regVal.put(FriendColumns.SOURCE_ID, Long.toString(sourceId));

        Uri uri = getContentResolver().insert(
                EventStreamContentProvider.Uris.FRIENDS_URI,
                regVal);

        return friendKey;
    }

    private long addSource(String name, int layoutOrder) {
        ContentValues regVal = new ContentValues();
        regVal.put(SourceColumns.ENABLED, "1");
        regVal.put(SourceColumns.NAME, name);
        regVal.put(SourceColumns.LAYOUT_ORDER, layoutOrder);
        regVal.put(PluginColumns.ICON_URI,
                "android.resource://com.sonyericsson.esdatasourceplugin/"
                + Integer.toString(R.drawable.generic_service));

        Uri uri = getContentResolver().insert(
                EventStreamContentProvider.Uris.SOURCE_URI,
                regVal);

        return ContentUris.parseId(uri);
    }

    private long addSource(String name) {
        return addSource(name, 0);
    }

    private boolean addPlugin() {
        Cursor cursor = null;
        boolean result = false;
        try {
            // Check if we already have instance in plug-in table.
            cursor = getContentResolver().query(
                    EventStreamContentProvider.Uris.PLUGIN_URI,
                    null, null, null, null);

            // Prepare plug-in data.
            ContentValues regVal = new ContentValues();

            regVal.put(PluginColumns.API_VERSION, "1");
            regVal.put(PluginColumns.CONFIGURATION_STATE, "2");
            regVal.put(PluginColumns.ICON_URI,
                    "android.resource://com.sonyericsson.esdatasourceplugin/"
                    + Integer.toString(R.drawable.generic_service));
            regVal.put(PluginColumns.NAME, "DataSource TestPlugin");

            if (cursor != null && cursor.getCount() > 0) {
                // Already row in table. Lets update the plug-in data.
                getContentResolver().update(
                        EventStreamContentProvider.Uris.PLUGIN_URI,
                        regVal, null, null);

                Log.d(LOG_TAG, "Updated data of test plug-in in Event Stream.");
            } else {
                // Register ourself for the first time.
                getContentResolver().insert(
                        EventStreamContentProvider.Uris.PLUGIN_URI,
                        regVal);

                result = true;
                Log.d(LOG_TAG, "Inserted test plug-in into Event Stream.");
            }
       } catch (Exception e) {
           Log.d(LOG_TAG, "Event Stream provider error: " + e.getMessage());
       } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
       return result;
    }

    private void deleteDataSet1() {
        /*
         * Delete plugin will trigger eventstreamengine to remove all data related
         * to this plugin.
         */
        try {
            int i = getContentResolver().delete(
                    EventStreamContentProvider.Uris.PLUGIN_URI,
                    null, null);

            getContentResolver().delete(mContactUri, null, null);
            if(i == 1) {
                Log.d(LOG_TAG, "Removed plugin and its data");
            } else if (i > 1) {
                Log.e(LOG_TAG, "Removed more than one row, i = " + i);
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Remove plugin: " + e.getMessage());
        }

    }

}
