
package com.sonyericsson.eventstream.facebookplugin;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.widget.EditText;

import com.sonyericsson.eventstream.facebookplugin.Facebook.ServiceState;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(PowerMockRunner.class)
@PrepareForTest( {
        FacebookPluginConfig.class, ComponentName.class, Activity.class, FacebookFactory.class,
        FacebookPluginApplication.class, Application.class, EditText.class, Dialog.class
})
public class FacebookPluginConfigTests {

    /**
     * Verify that the service is started (with correct parameters) when
     * we try to log in from the config activity.
     * @throws Exception
     */
    @Test
    public void testFacebookLogin() throws Exception {
//        String username = "erik";
//        String password = "test";
//
//        PowerMock.suppress(Activity.class.getConstructors());
//
//        // Mock objects
//        Context context = PowerMock.createMock(Context.class);
//        FacebookPluginConfig activity = PowerMock.createPartialMock(FacebookPluginConfig.class,
//                "startService", "getApplicationContext");
//        Intent intent = PowerMock.createMock(Intent.class);
//        ComponentName componentName = PowerMock.createMock(ComponentName.class);
//
//        // Expects
//        PowerMock.expectNew(Intent.class, Constants.AUTHENTICATE_INTENT).andReturn(intent).once();
//        EasyMock.expect(activity.getApplicationContext()).andReturn(context).once();
//        EasyMock.expect(intent.putExtra(Constants.USERNAME_EXTRA, username)).andReturn(intent)
//                .once();
//        EasyMock.expect(intent.putExtra(Constants.PASSWORD_EXTRA, password)).andReturn(intent)
//                .once();
//        EasyMock.expect(intent.putExtra(Constants.PLUGIN_KEY_PARAMETER, Constants.PLUGIN_KEY)).andReturn(intent)
//        .once();
//        EasyMock.expect(intent.setClass(context, FacebookService.class)).andReturn(intent).once();
//        EasyMock.expect(activity.startService(intent)).andReturn(componentName).once();
//
//        PowerMock.replayAll();
//        Whitebox.invokeMethod(activity, "callFacebookLogin", username, password);
//        PowerMock.verifyAll();
    }

    /**
     * Verify the behavior of the config activity when it is resumed and
     * the service is logged in to facebook (show logout dialog).
     * @throws Exception
     */
    @Test
    public void testResumeLogout() throws Exception {
//        PowerMock.suppress(Activity.class.getConstructors());
//
//        // Mock objects
//        FacebookPluginConfig activity = PowerMock.createPartialMock(FacebookPluginConfig.class,
//                "showDialog", "getApplication", "getApplicationContext");
//        FacebookPluginApplication application = PowerMock
//                .createMock(FacebookPluginApplication.class);
//        Facebook facebook = PowerMock.createMock(Facebook.class);
//        PowerMock.mockStatic(FacebookFactory.class);
//        PowerMock.mockStatic(FacebookPluginConfig.class);
//
//        // Expects
//        EasyMock.expect(activity.getApplication()).andReturn(application).once();
//        EasyMock.expect(activity.getApplicationContext()).andReturn(application);
//        EasyMock.expect(FacebookFactory.getFacebook(application)).andReturn(facebook);
//
//        application.addFacebookCallback(activity);
//        facebook.setServiceStateListener(activity);
//
//        EasyMock.expect(facebook.isLoggedIn()).andReturn(true).once();
//        activity.showDialog(FacebookPluginConfig.DIALOG_LOGOUT);
//
//        PowerMock.replayAll();
//        Whitebox.invokeMethod(activity, "resume");
//        PowerMock.verifyAll();
    }

    /**
     * Verify the behavior of the config activity when it is resumed and
     * the service is logging in to facebook (show progress dialog).
     * @throws Exception
     */
    @Test
    public void testResumeAuthorizing() throws Exception {
//        PowerMock.suppress(Activity.class.getConstructors());
//
//        // Mock objects
//        FacebookPluginConfig activity = PowerMock.createPartialMock(FacebookPluginConfig.class,
//                "showDialog", "getApplication", "getApplicationContext");
//        FacebookPluginApplication application = PowerMock
//                .createMock(FacebookPluginApplication.class);
//        Facebook facebook = PowerMock.createMock(Facebook.class);
//        PowerMock.mockStatic(FacebookFactory.class);
//        PowerMock.mockStatic(FacebookPluginConfig.class);
//
//        // Expects
//        EasyMock.expect(activity.getApplication()).andReturn(application).once();
//        EasyMock.expect(activity.getApplicationContext()).andReturn(application);
//        EasyMock.expect(FacebookFactory.getFacebook(application)).andReturn(facebook);
//
//        application.addFacebookCallback(activity);
//        facebook.setServiceStateListener(activity);
//
//        EasyMock.expect(facebook.isLoggedIn()).andReturn(false).once();
//        EasyMock.expect(facebook.getState()).andReturn(ServiceState.AUTHENTICATION_IN_PROGRESS).once();
//        activity.showDialog(FacebookPluginConfig.DIALOG_PROGRESS);
//
//        PowerMock.replayAll();
//        Whitebox.invokeMethod(activity, "resume");
//        PowerMock.verifyAll();
    }

    /**
     * Verify the behavior of the config activity when it is resumed and
     * the service is logged out of facebook (show disclaimer dialog).
     * @throws Exception
     */
    @Test
    public void testResumeLogin() throws Exception {
//        PowerMock.suppress(Activity.class.getConstructors());
//
//        // Mock objects
//        FacebookPluginConfig activity = PowerMock.createPartialMock(FacebookPluginConfig.class,
//                "showDialog", "getApplication", "getApplicationContext");
//        FacebookPluginApplication application = PowerMock
//                .createMock(FacebookPluginApplication.class);
//        Facebook facebook = PowerMock.createMock(Facebook.class);
//        PowerMock.mockStatic(FacebookFactory.class);
//        PowerMock.mockStatic(FacebookPluginConfig.class);
//
//        // Expects
//        EasyMock.expect(activity.getApplication()).andReturn(application).once();
//        EasyMock.expect(activity.getApplicationContext()).andReturn(application);
//        EasyMock.expect(FacebookFactory.getFacebook(application)).andReturn(facebook);
//
//        application.addFacebookCallback(activity);
//        facebook.setServiceStateListener(activity);
//
//        EasyMock.expect(facebook.isLoggedIn()).andReturn(false).once();
//        EasyMock.expect(facebook.getState()).andReturn(ServiceState.PASSIVE).once();
//        activity.showDialog(FacebookPluginConfig.DIALOG_DISCLAIMER);
//
//        PowerMock.replayAll();
//        Whitebox.invokeMethod(activity, "resume");
//        PowerMock.verifyAll();
    }


    /**
     * Verify that the password text box in the login dialog is cleared
     * when ever the dialog is prepared.
     * @throws Exception
     */
    @Test
    public void testPrepareLoginDialog() throws Exception {
//        PowerMock.suppress(Activity.class.getConstructors());
//
//        // Mock objects
//        FacebookPluginConfig activity = PowerMock.createPartialMock(FacebookPluginConfig.class,
//                "showDialog", "getApplication", "getApplicationContext");
//        EditText passwordEditor = PowerMock.createMock(EditText.class);
//        Dialog dialog = PowerMock.createMock(Dialog.class);
//
//        // Expects
//        EasyMock.expect(dialog.findViewById(R.id.login_password)).andReturn(passwordEditor).once();
//        passwordEditor.setText("");
//
//        PowerMock.replayAll();
//        Whitebox.invokeMethod(activity, "onPrepareDialog", FacebookPluginConfig.DIALOG_LOGIN, dialog, null);
//        PowerMock.verifyAll();
    }

}
