/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file
 * @author Niklas Karlsson (niklas.karlsson@sonyericsson.com)
 */
package com.sonyericsson.eventstream.facebookplugin;

import com.sonyericsson.eventstream.facebookplugin.Facebook.EventStorage.EventType;

import android.net.Uri;
import android.test.AndroidTestCase;

public class UFacebookPluginTestDeepLinking extends AndroidTestCase {
    private static String MY_FACEBOOK_ID = "1111111";
    private static String MY_FRIEND_ID = "33333333";
    private static String STATUS_PART = "12121212121";
    private static String FACEBOOK_EVENT_STATUS_ID = MY_FRIEND_ID + "_" + STATUS_PART;

    @Override
    public void setUp() throws Exception {
        Settings settings = new Settings(getContext());

        // Set up some values that should be available after a proper login
        settings.setAuthenticationToken("444MY_AUTH_TOKEN666");
        settings.setOwnId(MY_FACEBOOK_ID);
        settings.setSessionKey("111SESSION_KEY222_" + MY_FACEBOOK_ID);

        super.setUp();
    }

    @Override
    public void tearDown() throws Exception  {
        Settings settings = new Settings(getContext());

        settings.setAuthenticationToken(null);
        settings.setOwnId(null);
        settings.setSessionKey(null);

        super.tearDown();
    }

    public void testDeepLinkStatus() {
        Uri uri = FacebookDeepLink.getDeepLink(getContext(),
                MY_FACEBOOK_ID, FACEBOOK_EVENT_STATUS_ID, MY_FRIEND_ID, EventType.STATUS_EVENT);

        assertNotNull("The deep link uri is null", uri);
    }
}