/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.rssplugin;

import com.sonyericsson.eventstream.rssplugin.PluginConstants.EventStream.Intents;
import com.sonyericsson.eventstream.rssplugin.util.DBUtils;

import android.content.Intent;
import android.test.InstrumentationTestCase;

import junit.framework.Assert;

public class EventStreamListenerTests extends InstrumentationTestCase{

    @Override
    protected void tearDown() throws Exception {
        DBUtils.deletePluginAndSourceFromDatabase(getInstrumentation().getTargetContext());
        super.tearDown();
    }

    public void testRegisterPluginIntent() {
        DBUtils.deletePluginAndSourceFromDatabase(getInstrumentation().getTargetContext());
        boolean foundPlugin = DBUtils.isPluginInDB(getInstrumentation().getTargetContext());
        assertFalse(foundPlugin);
        boolean foundSource = DBUtils.isSourceInDB(getInstrumentation().getTargetContext());
        assertFalse(foundSource);

        Intent intent = new Intent(Intents.REGISTER_PLUGINS_REQUEST_INTENT);
        (new EventStreamListener()).onReceive(getInstrumentation().getTargetContext(), intent);

        try {
            Thread.sleep(DBUtils.DELAY);
        } catch (InterruptedException e) {
            Assert.fail("Thread sleep interrupted");
        }
        foundPlugin = DBUtils.isPluginInDB(getInstrumentation().getTargetContext());
        assertTrue(foundPlugin);

        foundSource = DBUtils.isSourceInDB(getInstrumentation().getTargetContext());
        assertTrue(foundSource);
    }

}

