/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.rssplugin;

import com.sonyericsson.eventstream.rssplugin.util.DBUtils;
import com.sonyericsson.eventstream.rssplugin.PluginConstants.ServiceIntentCmd;
import android.content.Intent;
import android.test.ServiceTestCase;

import java.util.ArrayList;
import java.util.List;

import junit.framework.Assert;

public class RssPluginServiceTests extends ServiceTestCase<RssPluginService> {

    private static int DELAY = 1000;

    public RssPluginServiceTests() {
        super(RssPluginService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        DBUtils.deletePluginAndSourceFromDatabase(getContext());
        super.tearDown();
    }

    public void testSynchronizeEvents() {
        startService(new Intent());
        DBUtils.deletePluginAndSourceFromDatabase(getContext());
        RssPluginService service = getService();
        Intent intent = new Intent();
        intent.putExtra(ServiceIntentCmd.SERVICE_COMMAND_KEY, ServiceIntentCmd.REGISTER_PLUGIN);
        service.onStartCommand(intent, 0, 0);
        try {
            Thread.sleep(DELAY);
        } catch (InterruptedException e) {
            Assert.fail("Thread sleep interrupted");
        }
        Channel channel = new Channel();
        channel.setLink("link");
        List<Item> itemList = new ArrayList<Item>();
        Item item = new Item();
        item.setLink("link");
        item.setTitle("title");
        item.setTimeOfDate(System.currentTimeMillis());
        item.setMediaThumbnail("media");
        itemList.add(item);
        item = new Item();
        item.setLink("link2");
        item.setTitle("title2");
        item.setTimeOfDate(System.currentTimeMillis());
        item.setMediaThumbnail("media2");
        itemList.add(item);
        channel.setItemList(itemList);
        List<Channel> channelList = new ArrayList<Channel>();
        channelList.add(channel);
        int nbrOfInsertedItems = service.synchronizeEvents(channelList);
        assertEquals(2, nbrOfInsertedItems);
    }

}

