/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.simpleui.utils;

import com.sonyericsson.simpleui.activity.SimpleUiInternal.Config;
import com.sonyericsson.simpleui.provider.EventStreamContentProvider;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Log;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

/**
 * Utility class for handling images.
 *
 */
public class ImageUtilities {

    public static Bitmap decodeImageFromUri(Context context, Uri imageUri) {
        Bitmap imageBitmap = null;
        String imageScheme = imageUri.getScheme();
        InputStream inputStream = null;

        if (Config.DEBUG) {
            Log.i(Config.LOG_TAG, "Image scheme = " + imageScheme);
        }

        try {
            if (ContentResolver.SCHEME_CONTENT.equals(imageScheme)
                    || ContentResolver.SCHEME_FILE.equals(imageScheme)
                    || ContentResolver.SCHEME_ANDROID_RESOURCE.equals(imageScheme)) {
                inputStream = context.getContentResolver().openInputStream(imageUri);
            } else if ("http".equals(imageScheme) || "https".equals(imageScheme)) {
                Uri cachedImageUri = new Uri.Builder().scheme(ContentResolver.SCHEME_CONTENT)
                .authority(EventStreamContentProvider.Uris.AUTHORITY).appendEncodedPath(
                        EventStreamContentProvider.Uris.ONLINE_IMAGE_CACHE_PATH)
                        .appendQueryParameter(
                                EventStreamContentProvider.Uris.ONLINE_IMAGE_URI_QUERY_PARAM,
                                imageUri.toString()).build();

                inputStream = context.getContentResolver().openInputStream(cachedImageUri);
            }
            if (inputStream != null) {
                imageBitmap = BitmapFactory.decodeStream(inputStream);
            }
        } catch (FileNotFoundException e) {
            if (Config.DEBUG) {
                Log.e(Config.LOG_TAG, "Failed loading, decoding or caching image filename " + imageUri);
            }
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    if (Config.DEBUG) {
                        Log.e(Config.LOG_TAG, "Failed to access image file " + imageUri);
                    }
                }
            }
        }

        return imageBitmap;
    }
}
