/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2009 Sony Ericsson Mobile Communications AB.         *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file
 * @author Mats Wilson (mats.wilson@sonyericsson.com)
 */

package com.sonyericsson.eventstream.telephonyplugin;

import android.app.Instrumentation;
import android.app.Instrumentation.ActivityMonitor;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PatternMatcher;
import android.test.InstrumentationTestCase;

public class UTelephonyPluginLaunchViewTests extends InstrumentationTestCase {

    private static final String FAKE_PHONE_NUMBER = "+4670200110011";

    private Context mContext;

    private Instrumentation mInsrt;

    @Override
    protected void setUp() throws Exception {
        mInsrt = getInstrumentation();
        mContext = mInsrt.getTargetContext();

        cleanup();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        cleanup();
    }

    /**
     * Verify that refresh intent trigger a new event
     */
    public void testReceiveViewNotification() {
        TelephonyPluginService service = new TelephonyPluginService();

        // Set intent filter
        IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_VIEW);
        filter.addDataScheme("sms");
        filter.addDataPath(FAKE_PHONE_NUMBER, PatternMatcher.PATTERN_LITERAL);

        Instrumentation.ActivityMonitor monitor = new ActivityMonitor(
                filter, null, true);
        mInsrt.addMonitor(monitor);

        service.launchMessageIntent(mContext, FAKE_PHONE_NUMBER);
        getInstrumentation().waitForIdleSync();

        // Verify the correct intent is launched
        assertEquals(1, monitor.getHits());
        mInsrt.removeMonitor(monitor);
    }

    private void cleanup() {
        mContext.getContentResolver().delete(
                PluginConstants.EventStream.EVENTSTREAM_EVENT_PROVIDER_URI, null, null);
        mContext.getContentResolver().delete(
                PluginConstants.EventStream.EVENTSTREAM_FRIEND_PROVIDER_URI, null, null);
        mContext.getContentResolver().delete(
                PluginConstants.EventStream.EVENTSTREAM_SOURCES_PROVIDER_URI, null, null);
        mContext.getContentResolver().delete(
                PluginConstants.EventStream.EVENTSTREAM_PLUGIN_PROVIDER_URI, null, null);
    }
}
