/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin;

import com.sonyericsson.eventstream.twitterplugin.utility.EventStreamHelper;

import android.test.AndroidTestCase;

public class UEventStreamHelperTests extends AndroidTestCase {

    /**
     * Make sure that we can handle null as in parameter
     */
    public void testIsPluginRegisteredParameterIsNull() throws Exception {
        assertFalse("Expected value to be false", EventStreamHelper.isPluginRegistered(null));
    }

    /**
     * Make sure that we can handle null as in parameter
     */
    public void testClearAllParameterIsNull() throws Exception {
        try {
            EventStreamHelper.clearAll(null);
        } catch(Exception e) {
            fail("Didn't expect exception to be thrown.");
        }
    }

    /**
     * Make sure that we can handle null as in parameter
     */
    public void testClearDataParameterIsNull() throws Exception {
        try {
            EventStreamHelper.clearData(null);
        } catch(Exception e) {
            fail("Didn't expect exception to be thrown.");
        }
    }
}
