/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin.twitter;

import android.content.Context;
import android.test.InstrumentationTestCase;

import twitter4j.TwitterException;

import com.sonyericsson.eventstream.twitterplugin.R;
import com.sonyericsson.eventstream.twitterplugin.twitter.TwitterPluginException.StatusCode;

public class UTwitterPluginExceptionTests extends InstrumentationTestCase {

    Context mContext;

    @Override
    protected void setUp() throws Exception {
        mContext = getInstrumentation().getTargetContext();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
    * Test to set and get the state
    */
   public void testGetStatusCodeUsingTwitterException() {
       // Bad value
       TwitterPluginException exception = new TwitterPluginException((TwitterException)null);
       assertEquals("Invalid code", StatusCode.INTERNAL_ERROR, exception.getStatusCode());
       TwitterException exeption = new TwitterException("", new Exception(), -1);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.INTERNAL_ERROR, exception.getStatusCode());

       // INTERNAL_ERROR
       exeption = new TwitterException("", new Exception(), TwitterException.BAD_REQUEST);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.INTERNAL_ERROR, exception.getStatusCode());
       exeption = new TwitterException("", new Exception(), TwitterException.FORBIDDEN);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.INTERNAL_ERROR, exception.getStatusCode());
       exeption = new TwitterException("", new Exception(), TwitterException.NOT_ACCEPTABLE);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.INTERNAL_ERROR, exception.getStatusCode());
       exeption = new TwitterException("", new Exception(), TwitterException.NOT_FOUND);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.INTERNAL_ERROR, exception.getStatusCode());
       exeption = new TwitterException("", new Exception(), TwitterException.OK);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.INTERNAL_ERROR, exception.getStatusCode());

       // SERVER_UNAVAILABLE
       exeption = new TwitterException("", new Exception(), TwitterException.ENHANCE_YOUR_CLAIM);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.SERVER_UNAVAILABLE, exception.getStatusCode());
       exeption = new TwitterException("", new Exception(), TwitterException.BAD_GATEWAY);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.SERVER_UNAVAILABLE, exception.getStatusCode());
       exeption = new TwitterException("", new Exception(), TwitterException.INTERNAL_SERVER_ERROR);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.SERVER_UNAVAILABLE, exception.getStatusCode());
       exeption = new TwitterException("", new Exception(), TwitterException.SERVICE_UNAVAILABLE);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.SERVER_UNAVAILABLE, exception.getStatusCode());

       // UNAUTHORIZED
       exeption = new TwitterException("", new Exception(), TwitterException.UNAUTHORIZED);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.UNAUTHORIZED, exception.getStatusCode());

       // NOT_MODIFIED
       exeption = new TwitterException("", new Exception(), TwitterException.NOT_MODIFIED);
       exception = new TwitterPluginException(exeption);
       assertEquals("Invalid code", StatusCode.NOT_MODIFIED, exception.getStatusCode());
   }

   /**
    * Test to set and get the state
    */
   public void testGetStatusCodeUsingStatusCode() {
       // Bad value
       TwitterPluginException exception = new TwitterPluginException((StatusCode)null);
       assertEquals("Invalid code", StatusCode.INTERNAL_ERROR, exception.getStatusCode());

       // INTERNAL_ERROR
       exception = new TwitterPluginException(StatusCode.INTERNAL_ERROR);
       assertEquals("Invalid code", StatusCode.INTERNAL_ERROR, exception.getStatusCode());

       // SERVER_UNAVAILABLE
       exception = new TwitterPluginException(StatusCode.SERVER_UNAVAILABLE);
       assertEquals("Invalid code", StatusCode.SERVER_UNAVAILABLE, exception.getStatusCode());

       // UNAUTHORIZED
       exception = new TwitterPluginException(StatusCode.UNAUTHORIZED);
       assertEquals("Invalid code", StatusCode.UNAUTHORIZED, exception.getStatusCode());

       // NOT_MODIFIED
       exception = new TwitterPluginException(StatusCode.NOT_MODIFIED);
       assertEquals("Invalid code", StatusCode.NOT_MODIFIED, exception.getStatusCode());
   }

   /**
    * Test to set and get the state
    */
   public void testGetStatusMessage() {
       Context context = getInstrumentation().getTargetContext();

       // Bad constructor value
       TwitterPluginException exception = new TwitterPluginException((StatusCode)null);
       String message = exception.getStatusCodeNotificationMessage(context);
       assertEquals("Wrong message for inparam null", context.getString(R.string.ts_twitter_notify_fetch_failed_operation_failed_txt), message);

       // Context null
       exception = new TwitterPluginException(StatusCode.NOT_MODIFIED);
       message = exception.getStatusCodeNotificationMessage(null);
       assertNull("Message should be null", message);

       // INTERNAL_ERROR
       exception = new TwitterPluginException(StatusCode.INTERNAL_ERROR);
       message = exception.getStatusCodeNotificationMessage(context);
       assertEquals("Wrong message for INTERNAL_ERROR", context.getString(R.string.ts_twitter_notify_fetch_failed_operation_failed_txt), message);

       // SERVER_UNAVAILABLE
       exception = new TwitterPluginException(StatusCode.SERVER_UNAVAILABLE);
       message = exception.getStatusCodeNotificationMessage(context);
       assertEquals("Wrong message for SERVER_UNAVAILABLE", context.getString(R.string.ts_twitter_notify_fetch_failed_servererror_txt), message);

       // UNAUTHORIZED
       exception = new TwitterPluginException(StatusCode.UNAUTHORIZED);
       message = exception.getStatusCodeNotificationMessage(context);
       assertEquals("Wrong message for UNAUTHORIZED", context.getString(R.string.ts_twitter_notify_fetch_failed_invalid_access_txt), message);

       // NOT_MODIFIED
       exception = new TwitterPluginException(StatusCode.NOT_MODIFIED);
       message = exception.getStatusCodeNotificationMessage(context);
       assertNull("Message should be null", message);
   }

}
